/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.windows;

import org.fax4j.FaxException;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.process.ExitCodeProcessOutputValidator;
import org.fax4j.spi.windows.WindowsProcessFaxClientSpi;
import org.fax4j.util.ProcessExecutorHelper;

public class WindowsProcessOutputValidator
extends ExitCodeProcessOutputValidator {
    public void validateProcessOutput(FaxClientSpi faxClientSpi, ProcessExecutorHelper.ProcessOutput processOutput, FaxActionType faxActionType) {
        super.validateProcessOutput(faxClientSpi, processOutput, faxActionType);
        String output = processOutput.getOutputText();
        if (output != null && output.length() > 0) {
            if (output.indexOf(WindowsProcessFaxClientSpi.Fax4jExeConstants.OPERATION_OUTPUT_DONE.toString()) == -1) {
                String prefix = WindowsProcessFaxClientSpi.Fax4jExeConstants.FAX_ERROR_OUTPUT_PREFIX.toString();
                int index = output.indexOf(prefix);
                int prefixLenght = prefix.length();
                String errorMessage = null;
                if (index != -1 && output.length() > (index += prefixLenght)) {
                    errorMessage = output.substring(index);
                    index = (errorMessage = errorMessage.trim()).indexOf("\n");
                    if (index != -1) {
                        errorMessage = errorMessage.substring(0, index);
                        errorMessage = errorMessage.trim();
                    }
                    if (errorMessage.length() == 0) {
                        errorMessage = null;
                    }
                }
                if (errorMessage == null) {
                    throw new FaxException("Error while invoking fax4j.exe, no error message detected.\nNative Output:\n" + output);
                }
                throw new FaxException("Error while invoking fax4j.exe, error: " + errorMessage + "\nNative Output:\n" + output);
            }
        } else {
            throw new FaxException("Error while invoking fax4j.exe, no output detected.");
        }
    }
}

