/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import org.fax4j.FaxException;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.util.CloseableResourceManager;
import org.fax4j.util.Connection;
import org.fax4j.util.ConnectionFactory;
import org.fax4j.util.ConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionFactory<T>
implements ConnectionFactory<T> {
    protected final Logger LOGGER;
    protected ConfigurationHolder factoryConfigurationHolder;

    public AbstractConnectionFactory() {
        LoggerManager loggerManager = LoggerManager.getInstance();
        this.LOGGER = loggerManager.getLogger();
    }

    @Override
    public final synchronized void initialize(ConfigurationHolder configurationHolder) {
        if (this.factoryConfigurationHolder != null) {
            throw new FaxException("Connection Factory already initialized");
        }
        this.factoryConfigurationHolder = configurationHolder;
        this.initializeImpl();
    }

    @Override
    public Connection<T> createConnection() {
        this.LOGGER.logInfo(new Object[]{"Opening a new connection from factory type: ", this.getClass().getName()}, null);
        T resource = this.createResourceImpl();
        if (resource == null) {
            throw new FaxException("Unable to create resource.");
        }
        Connection<T> connection = this.createConnectionForResource(resource);
        CloseableResourceManager.registerCloseable(connection);
        this.LOGGER.logInfo(new Object[]{"New connection opened."}, null);
        return connection;
    }

    @Override
    public void releaseConnection(Connection<T> connection) {
        if (connection != null) {
            try {
                this.LOGGER.logInfo(new Object[]{"Closing connection using factory type: ", this.getClass().getName()}, null);
                T resource = connection.getResource();
                this.releaseResource(resource);
                CloseableResourceManager.unregisterCloseable(connection);
                this.LOGGER.logInfo(new Object[]{"Connection closed."}, null);
            }
            catch (Exception exception) {
                this.LOGGER.logInfo(new Object[]{"Unable to close connection."}, exception);
            }
        }
    }

    protected final Connection<T> createConnectionForResource(T resource) {
        if (resource == null) {
            throw new FaxException("Connection resource not provided.");
        }
        ConnectionImpl<T> connection = new ConnectionImpl<T>(resource, this);
        return connection;
    }

    protected void releaseResource(T resource) {
        if (resource != null) {
            this.releaseResourceImpl(resource);
        }
    }

    protected abstract void initializeImpl();

    protected abstract T createResourceImpl();

    protected abstract void releaseResourceImpl(T var1);
}

