/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.IOException;
import org.fax4j.FaxException;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.util.ProcessExecutor;
import org.fax4j.util.ProcessExecutorHelper;

public abstract class AbstractProcessExecutor
implements ProcessExecutor {
    protected final Logger LOGGER;

    public AbstractProcessExecutor() {
        LoggerManager loggerManager = LoggerManager.getInstance();
        this.LOGGER = loggerManager.getLogger();
    }

    public ProcessExecutorHelper.ProcessOutput executeProcess(ConfigurationHolder configurationHolder, String command) throws IOException, InterruptedException {
        if (command == null || command.length() == 0) {
            throw new FaxException("Command not provided.");
        }
        String updatedCommand = command.trim();
        if (updatedCommand.length() == 0) {
            throw new FaxException("Command not provided.");
        }
        if (configurationHolder == null) {
            throw new FaxException("Configuration holder not provided.");
        }
        this.LOGGER.logDebug(new Object[]{"Invoking command: ", updatedCommand}, null);
        ProcessExecutorHelper.ProcessOutput processOutput = this.executeProcessImpl(configurationHolder, updatedCommand);
        int exitCode = processOutput.getExitCode();
        String outputText = processOutput.getOutputText();
        String errorText = processOutput.getErrorText();
        this.LOGGER.logDebug(new Object[]{"Invoked command: ", updatedCommand, " Exit Code: ", String.valueOf(exitCode), Logger.SYSTEM_EOL, "Output Text:", Logger.SYSTEM_EOL, outputText, Logger.SYSTEM_EOL, "Error Text:", Logger.SYSTEM_EOL, errorText}, null);
        return processOutput;
    }

    protected abstract ProcessExecutorHelper.ProcessOutput executeProcessImpl(ConfigurationHolder var1, String var2) throws IOException, InterruptedException;
}

