/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import org.fax4j.FaxException;
import org.fax4j.util.IOHelper;

public final class CloseableResourceManager {
    private static boolean active = true;
    protected static final Set<Closeable> RESOURCES = new HashSet<Closeable>();

    private CloseableResourceManager() {
    }

    public static void registerCloseable(Closeable closeable) {
        CloseableResourceManager.updateCloseable(true, closeable);
    }

    public static void unregisterCloseable(Closeable closeable) {
        CloseableResourceManager.updateCloseable(false, closeable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCloseable(boolean register, Closeable closeable) {
        boolean updated = false;
        Class<CloseableResourceManager> clazz = CloseableResourceManager.class;
        synchronized (CloseableResourceManager.class) {
            if (register) {
                if (active) {
                    RESOURCES.add(closeable);
                    updated = true;
                }
            } else {
                RESOURCES.remove(closeable);
                updated = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!updated) {
                throw new FaxException("Can not perform action, manager is being released.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void blockAndReleaseAllCloseableResources() {
        Class<CloseableResourceManager> clazz = CloseableResourceManager.class;
        synchronized (CloseableResourceManager.class) {
            active = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            Closeable[] closeables = null;
            Set<Closeable> set = RESOURCES;
            synchronized (set) {
                closeables = RESOURCES.toArray(new Closeable[RESOURCES.size()]);
            }
            int amount = closeables.length;
            Closeable closeable = null;
            for (int index = 0; index < amount; ++index) {
                closeable = closeables[index];
                IOHelper.closeResource(closeable);
            }
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new CloseableResourceShutdownHook());
    }

    private static class CloseableResourceShutdownHook
    extends Thread {
        public void run() {
            CloseableResourceManager.blockAndReleaseAllCloseableResources();
        }
    }
}

