/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.fax4j.FaxException;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.util.AbstractProcessExecutor;
import org.fax4j.util.IOHelper;
import org.fax4j.util.ProcessExecutorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessExecutor
extends AbstractProcessExecutor {
    @Override
    protected ProcessExecutorHelper.ProcessOutput executeProcessImpl(ConfigurationHolder configurationHolder, String command) throws IOException, InterruptedException {
        List<String> commandList = this.parseCommand(configurationHolder, command);
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        Process process = processBuilder.start();
        InputStream inputStream = process.getInputStream();
        IOHelper.OutputReadThread outputThread = new IOHelper.OutputReadThread(inputStream);
        outputThread.start();
        inputStream = process.getErrorStream();
        IOHelper.OutputReadThread errorThread = new IOHelper.OutputReadThread(inputStream);
        errorThread.start();
        int exitCode = process.waitFor();
        String outputText = outputThread.getText();
        String errorText = errorThread.getText();
        ProcessExecutorHelper.ProcessOutput processOutput = new ProcessExecutorHelper.ProcessOutput(outputText, errorText, exitCode);
        return processOutput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> parseCommand(ConfigurationHolder configurationHolder, String command) {
        LinkedList<String> commandList = new LinkedList<String>();
        StringBuilder buffer = new StringBuilder(command);
        String part = null;
        int quoteIndex = -1;
        int spaceIndex = -1;
        int length = -1;
        do {
            quoteIndex = buffer.indexOf("\"");
            spaceIndex = buffer.indexOf(" ");
            if (quoteIndex == -1) {
                buffer = spaceIndex == -1 ? this.addAllBuffer(commandList, buffer) : this.addPart(commandList, buffer, spaceIndex, true);
            } else if (spaceIndex == -1) {
                if (quoteIndex == -1) {
                    buffer = this.addAllBuffer(commandList, buffer);
                } else {
                    if (quoteIndex != 0) throw new FaxException("Unable to parse command: " + command);
                    quoteIndex = buffer.indexOf("\"", 1);
                    if (quoteIndex == -1) {
                        throw new FaxException("Unable to parse command: " + command);
                    }
                    buffer = this.addPart(commandList, buffer, quoteIndex, false);
                }
            } else if (quoteIndex < spaceIndex) {
                if (quoteIndex == 0) {
                    quoteIndex = buffer.indexOf("\"", 1);
                    if (quoteIndex == -1) {
                        throw new FaxException("Unable to parse command: " + command);
                    }
                    buffer = this.addPart(commandList, buffer, quoteIndex, false);
                } else {
                    buffer = this.addPart(commandList, buffer, spaceIndex, true);
                }
            } else {
                buffer = this.addPart(commandList, buffer, spaceIndex, true);
            }
            length = buffer.length();
            if (length <= 0) continue;
            part = buffer.toString();
            part = part.trim();
            buffer.delete(0, length);
            buffer.append(part);
            length = buffer.length();
        } while (length > 0);
        return commandList;
    }

    protected StringBuilder addAllBuffer(List<String> commandList, StringBuilder buffer) {
        commandList.add(buffer.toString());
        buffer.delete(0, buffer.length());
        return buffer;
    }

    protected StringBuilder addPart(List<String> commandList, StringBuilder buffer, int endIndex, boolean typeSpace) {
        int delta = 1;
        if (typeSpace) {
            delta = 0;
        }
        String part = buffer.substring(delta, endIndex);
        commandList.add(part);
        buffer.delete(0, endIndex + delta);
        return buffer;
    }
}

