/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.util.LibraryConfigurationLoader;

public final class IOHelper {
    private static final String DEFAULT_ENCODING = IOHelper.getDefaultEncodingImpl();
    private static final File FAX4J_TEMPORARY_DIRECTORY = IOHelper.getFax4jInternalTemporaryDirectoryImpl();

    private IOHelper() {
    }

    private static String getDefaultEncodingImpl() {
        String encoding = System.getProperty("file.encoding");
        return encoding;
    }

    private static File getFax4jInternalTemporaryDirectoryImpl() {
        boolean created;
        File temporaryFile = null;
        try {
            temporaryFile = File.createTempFile("temp_", ".temp");
        }
        catch (IOException exception) {
            throw new FaxException("Unable to create temporary file.", exception);
        }
        File temporaryDirectory = temporaryFile.getParentFile();
        boolean deleted = temporaryFile.delete();
        if (!deleted) {
            temporaryFile.deleteOnExit();
        }
        Properties properties = LibraryConfigurationLoader.readInternalConfiguration();
        String name = properties.getProperty("org.fax4j.product.name");
        String version = properties.getProperty("org.fax4j.product.version");
        File fax4jTemporaryDirectory = new File(temporaryDirectory, name + "_" + version);
        if (!fax4jTemporaryDirectory.exists() && !(created = fax4jTemporaryDirectory.mkdirs())) {
            throw new FaxException("Unable to create fax4j internal temporary directory: " + fax4jTemporaryDirectory);
        }
        return fax4jTemporaryDirectory;
    }

    private static String getEncodingToUse(String encoding) {
        String updatedEncoding = encoding;
        if (updatedEncoding == null) {
            updatedEncoding = IOHelper.getDefaultEncoding();
        }
        return updatedEncoding;
    }

    public static String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    public static File getFax4jInternalTemporaryDirectory() {
        return FAX4J_TEMPORARY_DIRECTORY;
    }

    public static byte[] convertStringToBinary(String text, String encoding) {
        byte[] data = null;
        if (text != null) {
            if (text.length() == 0) {
                data = new byte[]{};
            } else {
                LoggerManager loggerManager = LoggerManager.getInstance();
                Logger logger = loggerManager.getLogger();
                String encodingToUse = encoding;
                if (encodingToUse != null && encodingToUse.length() > 0) {
                    try {
                        data = text.getBytes(encodingToUse);
                    }
                    catch (UnsupportedEncodingException exception) {
                        logger.logError(new Object[]{"Unable to convert text to binary using encoding: ", encodingToUse, " using default system encoding."}, exception);
                    }
                }
                if (data == null) {
                    encodingToUse = IOHelper.getDefaultEncoding();
                    try {
                        data = text.getBytes(encodingToUse);
                    }
                    catch (UnsupportedEncodingException exception) {
                        logger.logError(new Object[]{"Unable to convert text to binary using default encoding: ", encodingToUse}, exception);
                        throw new FaxException("Unable to convert text to binary using encoding: " + encodingToUse, exception);
                    }
                }
            }
        }
        return data;
    }

    public static void closeResource(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Reader createReader(InputStream inputStream, String encoding) {
        String updatedEncoding = IOHelper.getEncodingToUse(encoding);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, updatedEncoding);
        }
        catch (UnsupportedEncodingException exception) {
            throw new FaxException("Unable to create reader, unsupported encoding: " + encoding, exception);
        }
        return reader;
    }

    public static Writer createWriter(OutputStream outputStream, String encoding) {
        String updatedEncoding = IOHelper.getEncodingToUse(encoding);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(outputStream, updatedEncoding);
        }
        catch (UnsupportedEncodingException exception) {
            throw new FaxException("Unable to create writer, unsupported encoding: " + encoding, exception);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextStream(Reader reader) throws IOException {
        char[] buffer = new char[5000];
        StringWriter stringWriter = new StringWriter();
        int read = -1;
        try {
            do {
                if ((read = reader.read(buffer)) == -1) continue;
                ((Writer)stringWriter).write(buffer, 0, read);
            } while (read != -1);
        }
        finally {
            IOHelper.closeResource(reader);
        }
        String text = ((Object)stringWriter).toString();
        return text;
    }

    public static String readTextFile(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        Reader reader = IOHelper.createReader(inputStream, null);
        String text = IOHelper.readTextStream(reader);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String text, File file) throws IOException {
        Writer writer = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            writer = IOHelper.createWriter(outputStream, null);
            writer.write(text);
        }
        catch (Throwable throwable) {
            IOHelper.closeResource(writer);
            throw throwable;
        }
        IOHelper.closeResource(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAndWriteStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[5000];
        int read = -1;
        try {
            do {
                if ((read = inputStream.read(buffer)) == -1) continue;
                outputStream.write(buffer, 0, read);
            } while (read != -1);
        }
        finally {
            IOHelper.closeResource(inputStream);
            IOHelper.closeResource(outputStream);
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5000);
        IOHelper.readAndWriteStreams(inputStream, outputStream);
        byte[] data = outputStream.toByteArray();
        return data;
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        byte[] data = IOHelper.readStream(inputStream);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] content, File file) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            ((OutputStream)outputStream).write(content);
        }
        catch (Throwable throwable) {
            IOHelper.closeResource(outputStream);
            throw throwable;
        }
        IOHelper.closeResource(outputStream);
    }

    public static File getFileFromPathList(String fileNameWithNoPath, String[] pathList) {
        File foundFile = null;
        if (pathList != null) {
            int amount = pathList.length;
            String directoryPath = null;
            File file = null;
            for (int index = 0; index < amount; ++index) {
                directoryPath = pathList[index];
                file = new File(directoryPath, fileNameWithNoPath);
                if (!file.exists() || !file.isFile()) continue;
                foundFile = file;
                break;
            }
        }
        return foundFile;
    }

    public static File getFileFromNativePath(String fileNameWithNoPath) {
        String systemPath = System.getProperty("java.library.path");
        String pathSeperator = System.getProperty("path.separator");
        String[] systemPathElements = systemPath.split(pathSeperator);
        File file = IOHelper.getFileFromPathList(fileNameWithNoPath, systemPathElements);
        return file;
    }

    public static class OutputReadThread
    extends Thread {
        private final InputStream INPUT_STREAM;
        private final ByteArrayOutputStream OUTPUT_STREAM = new ByteArrayOutputStream(5000);

        public OutputReadThread(InputStream inputStream) {
            this.INPUT_STREAM = inputStream;
        }

        public void run() {
            byte[] buffer = new byte[100];
            int read = -1;
            try {
                do {
                    if ((read = this.INPUT_STREAM.read(buffer)) == -1) continue;
                    this.OUTPUT_STREAM.write(buffer, 0, read);
                } while (read != -1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getText() throws UnsupportedEncodingException {
            String encoding = IOHelper.getDefaultEncoding();
            String text = this.OUTPUT_STREAM.toString(encoding);
            return text;
        }
    }
}

