/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.util.ReflectionHelper;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryConfigurationLoader {
    private static Map<String, String> systemConfiguration;
    public static final String CONFIGURATION_FILE_NAME = "fax4j.properties";

    private LibraryConfigurationLoader() {
    }

    private static void closeResource(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadProperties(Properties properties, InputStream inputStream, boolean internal) {
        try {
            properties.load(inputStream);
            LibraryConfigurationLoader.closeResource(inputStream);
        }
        catch (Exception exception) {
            LibraryConfigurationLoader.closeResource(inputStream);
            String prefix = "External";
            if (internal) {
                prefix = "Internal";
            }
            throw new FaxException(prefix + " " + CONFIGURATION_FILE_NAME + " not found.", exception);
        }
    }

    public static Properties readInternalConfiguration() {
        Properties properties = new Properties();
        ClassLoader classLoader = ReflectionHelper.getThreadContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/fax4j/fax4j.properties");
        LibraryConfigurationLoader.loadProperties(properties, inputStream, true);
        return properties;
    }

    public static Properties readInternalAndExternalConfiguration() {
        Properties properties = LibraryConfigurationLoader.readInternalConfiguration();
        ClassLoader classLoader = ReflectionHelper.getThreadContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(CONFIGURATION_FILE_NAME);
        if (inputStream != null) {
            LibraryConfigurationLoader.loadProperties(properties, inputStream, false);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getSystemConfiguration() {
        if (systemConfiguration != null) return systemConfiguration;
        Class<LibraryConfigurationLoader> clazz = LibraryConfigurationLoader.class;
        synchronized (LibraryConfigurationLoader.class) {
            if (systemConfiguration != null) return systemConfiguration;
            Properties properties = LibraryConfigurationLoader.readInternalAndExternalConfiguration();
            Map<String, String> map = new HashMap<String, String>(properties.size());
            SpiUtil.copyPropertiesToMap(properties, map);
            map = new HashMap<String, String>(map);
            map = Collections.unmodifiableMap(map);
            systemConfiguration = map;
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemConfiguration;
        }
    }
}

