/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.util.DefaultProcessExecutor;
import org.fax4j.util.ProcessExecutor;
import org.fax4j.util.ReflectionHelper;

public final class ProcessExecutorHelper {
    private static final Map<String, ProcessExecutor> PROCESS_EXECUTERS = new HashMap<String, ProcessExecutor>(20);

    private ProcessExecutorHelper() {
    }

    public static ProcessOutput executeProcess(ConfigurationHolder configurationHolder, String command) {
        ProcessExecutor processExecutor;
        String className = configurationHolder.getConfigurationValue("org.fax4j.process.executer.class.name");
        if (className == null) {
            className = DefaultProcessExecutor.class.getName();
        }
        if ((processExecutor = PROCESS_EXECUTERS.get(className)) == null) {
            processExecutor = (ProcessExecutor)ReflectionHelper.createInstance(className);
            PROCESS_EXECUTERS.put(className, processExecutor);
        }
        ProcessOutput processOutput = null;
        try {
            processOutput = processExecutor.executeProcess(configurationHolder, command);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("Error while invoking process, command: " + command, exception);
        }
        return processOutput;
    }

    public static class ProcessOutput {
        private final String OUTPUT_TEXT;
        private final String ERROR_TEXT;
        private final int EXIT_CODE;

        public ProcessOutput(String outputText, String errorText, int exitCode) {
            this.OUTPUT_TEXT = outputText;
            this.ERROR_TEXT = errorText;
            this.EXIT_CODE = exitCode;
        }

        public String getOutputText() {
            return this.OUTPUT_TEXT;
        }

        public String getErrorText() {
            return this.ERROR_TEXT;
        }

        public int getExitCode() {
            return this.EXIT_CODE;
        }
    }
}

