/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.fax4j.FaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        return classLoader;
    }

    public static Class<?> getType(String className) {
        ClassLoader classLoader = ReflectionHelper.getThreadContextClassLoader();
        Class<?> type = null;
        try {
            type = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new FaxException("Unable to load class: " + className, exception);
        }
        return type;
    }

    public static Object createInstance(Class<?> type) {
        Object instance = null;
        try {
            instance = type.newInstance();
        }
        catch (Exception exception) {
            throw new FaxException("Unable to create new instance of type: " + type, exception);
        }
        return instance;
    }

    public static Object createInstance(String className) {
        Class<?> type = ReflectionHelper.getType(className);
        Object instance = ReflectionHelper.createInstance(type);
        return instance;
    }

    public static Object invokeMethod(Class<?> type, Object instance, String methodName, Class<?>[] inputTypes, Object[] input) {
        Method method = null;
        try {
            method = type.getDeclaredMethod(methodName, inputTypes);
        }
        catch (Exception exception) {
            throw new FaxException("Unable to extract method: " + methodName + " from type: " + type, exception);
        }
        method.setAccessible(true);
        Object output = null;
        try {
            output = method.invoke(instance, input);
        }
        catch (Exception exception) {
            throw new FaxException("Unable to invoke method: " + methodName + " of type: " + type, exception);
        }
        return output;
    }

    public static Field getField(Class<?> type, String fieldName) {
        Field field = null;
        try {
            field = type.getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            throw new FaxException("Unable to extract field: " + fieldName + " from type: " + type, exception);
        }
        field.setAccessible(true);
        return field;
    }
}

