/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpiUtil {
    public static final String EMPTY_STRING = "";
    public static final URLTemplateParameterEncoder URL_ENCODER = new URLTemplateParameterEncoder();
    public static final String UTF_8_ENCODING_NAME = "UTF-8";
    public static final String TEMPLATE_PARAMETER_PREFIX = "${";
    public static final String TEMPLATE_PARAMETER_SUFFIX = "}";
    public static final String FILE_TEMPLATE_PARAMETER = "file";
    public static final String TARGET_ADDRESS_TEMPLATE_PARAMETER = "target.address";
    public static final String TARGET_NAME_TEMPLATE_PARAMETER = "target.name";
    public static final String SENDER_NAME_TEMPLATE_PARAMETER = "sender.name";
    public static final String SENDER_FAX_NUMBER_TEMPLATE_PARAMETER = "sender.fax.number";
    public static final String SENDER_EMAIL_TEMPLATE_PARAMETER = "sender.email";
    public static final String FAX_JOB_ID_TEMPLATE_PARAMETER = "fax.job.id";
    public static final String FILE_TEMPLATE_PARAMETER_STRING = "${file}";
    public static final String TARGET_ADDRESS_TEMPLATE_PARAMETER_STRING = "${target.address}";
    public static final String TARGET_NAME_TEMPLATE_PARAMETER_STRING = "${target.name}";
    public static final String SENDER_NAME_TEMPLATE_PARAMETER_STRING = "${sender.name}";
    public static final String SENDER_FAX_NUMBER_TEMPLATE_PARAMETER_STRING = "${sender.fax.number}";
    public static final String SENDER_EMAIL_TEMPLATE_PARAMETER_STRING = "${sender.email}";
    public static final String FAX_JOB_ID_TEMPLATE_PARAMETER_STRING = "${sender.email}";

    private SpiUtil() {
    }

    public static void copyPropertiesToMap(Properties source, Map<String, String> target) {
        if (source != null) {
            Iterator<Map.Entry<Object, Object>> iterator = source.entrySet().iterator();
            Map.Entry<Object, Object> entry = null;
            String key = null;
            String value = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                target.put(key, value);
            }
        }
    }

    public static String formatTemplate(String template, FaxJob faxJob, TemplateParameterEncoder encoder, boolean getFileContent, boolean fullFilePath) {
        LoggerManager loggerManager = LoggerManager.getInstance();
        Logger logger = loggerManager.getLogger();
        logger.logDebug(new Object[]{"Formatting template:", Logger.SYSTEM_EOL, template}, null);
        String text = template;
        if (text != null) {
            String value = null;
            if (text.indexOf(FILE_TEMPLATE_PARAMETER_STRING) != -1) {
                if (getFileContent) {
                    value = SpiUtil.getFileParameterValue(faxJob);
                } else if (fullFilePath) {
                    value = faxJob.getFilePath();
                } else {
                    File file = faxJob.getFile();
                    value = file.getName();
                }
                text = SpiUtil.replaceTemplateParameter(text, FILE_TEMPLATE_PARAMETER_STRING, value, encoder);
            }
            value = faxJob.getTargetAddress();
            text = SpiUtil.replaceTemplateParameter(text, TARGET_ADDRESS_TEMPLATE_PARAMETER_STRING, value, encoder);
            value = faxJob.getTargetName();
            text = SpiUtil.replaceTemplateParameter(text, TARGET_NAME_TEMPLATE_PARAMETER_STRING, value, encoder);
            value = faxJob.getSenderName();
            text = SpiUtil.replaceTemplateParameter(text, SENDER_NAME_TEMPLATE_PARAMETER_STRING, value, encoder);
            value = faxJob.getSenderFaxNumber();
            text = SpiUtil.replaceTemplateParameter(text, SENDER_FAX_NUMBER_TEMPLATE_PARAMETER_STRING, value, encoder);
            value = faxJob.getSenderEmail();
            text = SpiUtil.replaceTemplateParameter(text, "${sender.email}", value, encoder);
            value = faxJob.getID();
            text = SpiUtil.replaceTemplateParameter(text, "${sender.email}", value, encoder);
        }
        logger.logDebug(new Object[]{"Formated template:", Logger.SYSTEM_EOL, text}, null);
        return text;
    }

    public static String replaceTemplateParameter(String template, String parameter, String value, TemplateParameterEncoder encoder) {
        String text = template;
        if (text != null && parameter != null) {
            String updatedValue = value;
            if (updatedValue == null) {
                updatedValue = EMPTY_STRING;
            } else if (encoder != null) {
                updatedValue = encoder.encodeTemplateParameter(updatedValue);
            }
            text = text.replace(parameter, updatedValue);
        }
        return text;
    }

    public static String urlEncode(String text) {
        String urlEncodedString = text;
        if (text != null) {
            try {
                urlEncodedString = URLEncoder.encode(text, UTF_8_ENCODING_NAME);
            }
            catch (UnsupportedEncodingException exception) {
                throw new FaxException("Error while URL encoding text.", exception);
            }
        }
        return urlEncodedString;
    }

    public static String urlDecode(String text) {
        String urlEncodedString = text;
        if (text != null) {
            try {
                urlEncodedString = URLDecoder.decode(text, UTF_8_ENCODING_NAME);
            }
            catch (UnsupportedEncodingException exception) {
                throw new FaxException("Error while URL decoding text.", exception);
            }
        }
        return urlEncodedString;
    }

    private static String getFileParameterValue(FaxJob faxJob) {
        String value = null;
        File file = faxJob.getFile();
        if (file != null) {
            try {
                value = IOHelper.readTextFile(faxJob.getFile());
            }
            catch (IOException exception) {
                throw new FaxException("Error while reading file.", exception);
            }
        }
        return value;
    }

    public static class URLTemplateParameterEncoder
    implements TemplateParameterEncoder {
        public String encodeTemplateParameter(String text) {
            return SpiUtil.urlEncode(text);
        }
    }

    public static interface TemplateParameterEncoder {
        public String encodeTemplateParameter(String var1);
    }
}

