/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.jasperreports.charts.util.AbstractChartRenderableFactory;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleRenderToImageAwareDataRenderer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SvgChartRendererFactory
extends AbstractChartRenderableFactory {
    @Override
    public Renderable getRenderable(JasperReportsContext jasperReportsContext, JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D grx = new SVGGraphics2D(document);
        grx.setSVGCanvasSize(rectangle.getBounds().getSize());
        List<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            areaHyperlinks = ChartUtil.getImageAreaHyperlinks(chart, chartHyperlinkProvider, (Graphics2D)grx, rectangle);
        } else {
            chart.draw((Graphics2D)grx, rectangle);
        }
        try {
            StringWriter swriter = new StringWriter();
            grx.stream((Writer)swriter);
            byte[] svgData = swriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
            return new SimpleRenderToImageAwareDataRenderer(svgData, areaHyperlinks);
        }
        catch (SVGGraphics2DIOException e) {
            throw new JRRuntimeException(e);
        }
    }
}

