/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lept4j.util;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.lept4j.Leptonica1;
import net.sourceforge.lept4j.Pix;

public class LeptUtils {
    static final String JAI_IMAGE_WRITER_MESSAGE = "Need to install JAI Image I/O package.\nhttps://java.net/projects/jai-imageio/";
    static final String TIFF_FORMAT = "tiff";

    public static BufferedImage convertPixToImage(Pix pix) throws IOException {
        PointerByReference pointerByReference = new PointerByReference();
        NativeSizeByReference nativeSizeByReference = new NativeSizeByReference();
        int n = 4;
        Leptonica1.pixWriteMem(pointerByReference, nativeSizeByReference, pix, n);
        byte[] byArray = pointerByReference.getValue().getByteArray(0L, nativeSizeByReference.getValue().intValue());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        return bufferedImage;
    }

    public static Pix convertImageToPix(BufferedImage bufferedImage) throws IOException {
        ByteBuffer byteBuffer = LeptUtils.getImageByteBuffer(bufferedImage);
        Pix pix = Leptonica1.pixReadMem(byteBuffer, new NativeSize(byteBuffer.capacity()));
        return pix;
    }

    static ByteBuffer getImageByteBuffer(RenderedImage renderedImage) throws IOException {
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(iIOMetadata, new IIOImage(renderedImage, null, null), (ImageWriteParam)tIFFImageWriteParam);
        imageWriter.dispose();
        imageOutputStream.seek(0L);
        byte[] byArray = new byte[(int)imageOutputStream.length()];
        imageOutputStream.read(byArray);
        imageOutputStream.close();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }
}

