/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lept4j.util;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.lept4j.Leptonica;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LoadLibs {
    private static final String JNA_LIBRARY_PATH = "jna.library.path";
    public static final String LEPT4J_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"), "lept4j").getPath();
    public static final String LIB_NAME = "liblept171";
    public static final String LIB_NAME_NON_WIN = "lept";
    private static final Logger logger = Logger.getLogger(LoadLibs.class.getName());

    public static Leptonica getLeptonicaInstance() {
        return (Leptonica)Native.loadLibrary((String)LoadLibs.getLeptonicaLibName(), Leptonica.class);
    }

    public static String getLeptonicaLibName() {
        return Platform.isWindows() ? LIB_NAME : LIB_NAME_NON_WIN;
    }

    public static File extractNativeResources(String string) {
        File file = null;
        try {
            file = new File(LEPT4J_TEMP_DIR, string);
            URL uRL = LoadLibs.class.getResource(string.startsWith("/") ? string : "/" + string);
            if (uRL == null) {
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                LoadLibs.copyJarResourceToDirectory((JarURLConnection)uRLConnection, file);
            } else {
                FileUtils.copyDirectory((File)new File(uRL.getPath()), (File)file);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        return file;
    }

    static void copyJarResourceToDirectory(JarURLConnection jarURLConnection, File file) {
        try {
            JarFile jarFile = jarURLConnection.getJarFile();
            String string = jarURLConnection.getEntryName() + "/";
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.substring(string.length());
                File file2 = new File(file, string3);
                if (jarEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                file2.deleteOnExit();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file2);
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        File file = LoadLibs.extractNativeResources(Platform.RESOURCE_PREFIX);
        if (file != null && file.exists()) {
            String string = System.getProperty(JNA_LIBRARY_PATH);
            if (null == string || string.isEmpty()) {
                System.setProperty(JNA_LIBRARY_PATH, file.getPath());
            } else {
                System.setProperty(JNA_LIBRARY_PATH, string + File.pathSeparator + file.getPath());
            }
        }
    }
}

