package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;
/**
 * watershed.h<br>
 *     Simple data structure to hold watershed data.<br>
 *     All data here is owned by the L_WShed and must be freed.<br>
 * <i>native declaration : watershed.h:27</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_WShed extends Structure {
	/**
	 * clone of input 8 bpp pixs<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixs;
	/**
	 * clone of input 1 bpp seed (marker) pixm<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixm;
	/**
	 * minimum depth allowed for a watershed<br>
	 * C type : l_int32
	 */
	public int mindepth;
	/**
	 * 16 bpp label pix<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixlab;
	/**
	 * scratch pix for computing wshed regions<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixt;
	/**
	 * line ptrs for pixs<br>
	 * C type : void**
	 */
	public PointerByReference lines8;
	/**
	 * line ptrs for pixm<br>
	 * C type : void**
	 */
	public PointerByReference linem1;
	/**
	 * line ptrs for pixlab<br>
	 * C type : void**
	 */
	public PointerByReference linelab32;
	/**
	 * line ptrs for pixt<br>
	 * C type : void**
	 */
	public PointerByReference linet1;
	/**
	 * result: 1 bpp pixa of watersheds<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixad;
	/**
	 * pta of initial seed pixels<br>
	 * C type : Pta*
	 */
	public net.sourceforge.lept4j.Pta.ByReference ptas;
	/**
	 * numa of seed indicators; 0 if completed<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference nasi;
	/**
	 * numa of initial seed heights<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference nash;
	/**
	 * numa of initial minima heights<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference namh;
	/**
	 * result: numa of watershed levels<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference nalevels;
	/**
	 * number of seeds (markers)<br>
	 * C type : l_int32
	 */
	public int nseeds;
	/**
	 * number of minima different from seeds<br>
	 * C type : l_int32
	 */
	public int nother;
	/**
	 * lut for pixel indices<br>
	 * C type : l_int32*
	 */
	public IntByReference lut;
	/**
	 * back-links into lut, for updates<br>
	 * C type : Numa**
	 */
	public net.sourceforge.lept4j.Numa.ByReference[] links;
	/**
	 * size of links array<br>
	 * C type : l_int32
	 */
	public int arraysize;
	/**
	 * set to 1 for debug output<br>
	 * C type : l_int32
	 */
	public int debug;
	public L_WShed() {
		super();
	}
	protected List<? > getFieldOrder() {
		return Arrays.asList("pixs", "pixm", "mindepth", "pixlab", "pixt", "lines8", "linem1", "linelab32", "linet1", "pixad", "ptas", "nasi", "nash", "namh", "nalevels", "nseeds", "nother", "lut", "links", "arraysize", "debug");
	}
	public L_WShed(Pointer peer) {
		super(peer);
		read();
	}
	public static class ByReference extends L_WShed implements Structure.ByReference {
		
	};
	public static class ByValue extends L_WShed implements Structure.ByValue {
		
	};
}
