package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;
/**
 * Expandable pointer queue for arbitrary void* data<br>
 * <i>native declaration : queue.h:7</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_Queue extends Structure {
	/**
	 * size of allocated ptr array<br>
	 * C type : l_int32
	 */
	public int nalloc;
	/**
	 * location of head (in ptrs) from the<br>
	 * C type : l_int32
	 */
	public int nhead;
	/**
	 * number of elements stored in the queue<br>
	 * C type : l_int32
	 */
	public int nelem;
	/**
	 * ptr array<br>
	 * C type : void**
	 */
	public PointerByReference array;
	/**
	 * auxiliary stack<br>
	 * C type : L_Stack*
	 */
	public net.sourceforge.lept4j.L_Stack.ByReference stack;
	public L_Queue() {
		super();
	}
	protected List<? > getFieldOrder() {
		return Arrays.asList("nalloc", "nhead", "nelem", "array", "stack");
	}
	/**
	 * @param nalloc size of allocated ptr array<br>
	 * C type : l_int32<br>
	 * @param nhead location of head (in ptrs) from the<br>
	 * C type : l_int32<br>
	 * @param nelem number of elements stored in the queue<br>
	 * C type : l_int32<br>
	 * @param array ptr array<br>
	 * C type : void**<br>
	 * @param stack auxiliary stack<br>
	 * C type : L_Stack*
	 */
	public L_Queue(int nalloc, int nhead, int nelem, PointerByReference array, net.sourceforge.lept4j.L_Stack.ByReference stack) {
		super();
		this.nalloc = nalloc;
		this.nhead = nhead;
		this.nelem = nelem;
		this.array = array;
		this.stack = stack;
	}
	public L_Queue(Pointer peer) {
		super(peer);
		read();
	}
	public static class ByReference extends L_Queue implements Structure.ByReference {
		
	};
	public static class ByValue extends L_Queue implements Structure.ByValue {
		
	};
}
