package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;
/**
 * recog.h<br>
 * <pre><br>
 *     This is a simple utility for training and recognizing individual<br>
 *     machine-printed text characters.  It is designed to be adapted<br>
 *     to a particular set of character images; e.g., from a book.<br>
 *     There are two methods of training the recognizer.  In the most<br>
 *     simple, a set of bitmaps has been labeled by some means, such<br>
 *     a generic OCR program.  This is input either one template at a time<br>
 *     or as a pixa of templates, to a function that creates a recog.<br>
 *     If in a pixa, the text string label must be embedded in the<br>
 *     text field of each pix.<br>
 *     If labeled data is not available, we start with a bootstrap<br>
 *     recognizer (BSR) that has labeled data from a variety of sources.<br>
 *     These images are scaled, typically to a fixed height, and then<br>
 *     fed similarly scaled unlabeled images from the source (e.g., book),<br>
 *     and the BSR attempts to identify them.  All images that have<br>
 *     a high enough correlation score with one of the templates in the<br>
 *     BSR are emitted in a pixa, which now holds unscaled and labeled<br>
 *     templates from the source.  This is the generator for a book adapted<br>
 *     recognizer (BAR).<br>
 *     The pixa should always be thought of as the primary structure.<br>
 *     It is the generator for the recog, because a recog is built<br>
 *     from a pixa of unscaled images.<br>
 *     New image templates can be added to a recog as long as it is<br>
 *     in training mode.  Once training is finished, to add templates<br>
 *     it is necessary to extract the generating pixa, add templates<br>
 *     to that pixa, and make a new recog.  Similarly, we do not<br>
 *     join two recog; instead, we simply join their generating pixa,<br>
 *     and make a recog from that.<br>
 *     To remove outliers from a pixa of labeled pix, make a recog,<br>
 *     determine the outliers, and generate a new pixa with the<br>
 *     outliers removed.  The outliers are determined by building<br>
 *     special templates for each character set that are scaled averages<br>
 *     of the individual templates.  Then a correlation score is found<br>
 *     between each template and the averaged templates.  There are<br>
 *     two implementations; outliers are determined as either:<br>
 *      (1) a template having a correlation score with its class average<br>
 *          that is below a threshold, or<br>
 *      (2) a template having a correlation score with its class average<br>
 *          that is smaller than the correlation score with the average<br>
 *          of another class.<br>
 *     Outliers are removed from the generating pixa.  Scaled averaging<br>
 *     is only performed for determining outliers and for splitting<br>
 *     characters; it is never used in a trained recognizer for identifying<br>
 *     unlabeled samples.<br>
 *     Two methods using averaged templates are provided for splitting<br>
 *     touching characters:<br>
 *      (1) greedy matching<br>
 *      (2) document image decoding (DID)<br>
 *     The DID method is the default.  It is about 5x faster and<br>
 *     possibly more accurate.<br>
 *     Once a BAR has been made, unlabeled sample images are identified<br>
 *     by finding the individual template in the BAR with highest<br>
 *     correlation.  The input images and images in the BAR can be<br>
 *     represented in two ways:<br>
 *      (1) as scanned, binarized to 1 bpp<br>
 *      (2) as a width-normalized outline formed by thinning to a<br>
 *          skeleton and then dilating by a fixed amount.<br>
 *     The recog can be serialized to file and read back.  The serialized<br>
 *     version holds the templates used for correlation (which may have<br>
 *     been modified by scaling and turning into lines from the unscaled<br>
 *     templates), plus, for arbitrary character sets, the UTF8<br>
 *     representation and the lookup table mapping from the character<br>
 *     representation to index.<br>
 *     Why do we not use averaged templates for recognition?<br>
 *     Letterforms can take on significantly different shapes (eg.,<br>
 *     the letters 'a' and 'g'), and it makes no sense to average these.<br>
 *     The previous version of this utility allowed multiple recognizers<br>
 *     to exist, but this is an unnecessary complication if recognition<br>
 *     is done on all samples instead of on averages.<br>
 * </pre><br>
 * <i>native declaration : recog.h:126</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_Recog extends Structure {
	/**
	 * scale all examples to this width;<br>
	 * C type : l_int32
	 */
	public int scalew;
	/**
	 * scale all examples to this height;<br>
	 * C type : l_int32
	 */
	public int scaleh;
	/**
	 * use a value &gt; 0 to convert the bitmap<br>
	 * C type : l_int32
	 */
	public int linew;
	/**
	 * template use: use either the average<br>
	 * C type : l_int32
	 */
	public int templ_use;
	/**
	 * initialize container arrays to this<br>
	 * C type : l_int32
	 */
	public int maxarraysize;
	/**
	 * size of character set<br>
	 * C type : l_int32
	 */
	public int setsize;
	/**
	 * for binarizing if depth &gt; 1<br>
	 * C type : l_int32
	 */
	public int threshold;
	/**
	 * vertical jiggle on nominal centroid<br>
	 * C type : l_int32
	 */
	public int maxyshift;
	/**
	 * one of L_ARABIC_NUMERALS, etc.<br>
	 * C type : l_int32
	 */
	public int charset_type;
	/**
	 * expected number of classes in charset<br>
	 * C type : l_int32
	 */
	public int charset_size;
	/**
	 * min number of samples without padding<br>
	 * C type : l_int32
	 */
	public int min_nopad;
	/**
	 * number of training samples<br>
	 * C type : l_int32
	 */
	public int num_samples;
	/**
	 * min width averaged unscaled templates<br>
	 * C type : l_int32
	 */
	public int minwidth_u;
	/**
	 * max width averaged unscaled templates<br>
	 * C type : l_int32
	 */
	public int maxwidth_u;
	/**
	 * min height averaged unscaled templates<br>
	 * C type : l_int32
	 */
	public int minheight_u;
	/**
	 * max height averaged unscaled templates<br>
	 * C type : l_int32
	 */
	public int maxheight_u;
	/**
	 * min width averaged scaled templates<br>
	 * C type : l_int32
	 */
	public int minwidth;
	/**
	 * max width averaged scaled templates<br>
	 * C type : l_int32
	 */
	public int maxwidth;
	/**
	 * set to 1 when averaged bitmaps are made<br>
	 * C type : l_int32
	 */
	public int ave_done;
	/**
	 * set to 1 when training is complete or<br>
	 * C type : l_int32
	 */
	public int train_done;
	/**
	 * max width/height ratio to split<br>
	 * C type : l_float32
	 */
	public float max_wh_ratio;
	/**
	 * max of max/min template height ratio<br>
	 * C type : l_float32
	 */
	public float max_ht_ratio;
	/**
	 * min component width kept in splitting<br>
	 * C type : l_int32
	 */
	public int min_splitw;
	/**
	 * max component height kept in splitting<br>
	 * C type : l_int32
	 */
	public int max_splith;
	/**
	 * text array for arbitrary charset<br>
	 * C type : Sarray*
	 */
	public net.sourceforge.lept4j.Sarray.ByReference sa_text;
	/**
	 * index-to-char lut for arbitrary charset<br>
	 * C type : L_Dna*
	 */
	public net.sourceforge.lept4j.L_Dna.ByReference dna_tochar;
	/**
	 * table for finding centroids<br>
	 * C type : l_int32*
	 */
	public IntByReference centtab;
	/**
	 * table for finding pixel sums<br>
	 * C type : l_int32*
	 */
	public IntByReference sumtab;
	/**
	 * all unscaled templates for each class<br>
	 * C type : Pixaa*
	 */
	public net.sourceforge.lept4j.Pixaa.ByReference pixaa_u;
	/**
	 * centroids of all unscaled templates<br>
	 * C type : Ptaa*
	 */
	public net.sourceforge.lept4j.Ptaa.ByReference ptaa_u;
	/**
	 * area of all unscaled templates<br>
	 * C type : Numaa*
	 */
	public net.sourceforge.lept4j.Numaa.ByReference naasum_u;
	/**
	 * all (scaled) templates for each class<br>
	 * C type : Pixaa*
	 */
	public net.sourceforge.lept4j.Pixaa.ByReference pixaa;
	/**
	 * centroids of all (scaledl) templates<br>
	 * C type : Ptaa*
	 */
	public net.sourceforge.lept4j.Ptaa.ByReference ptaa;
	/**
	 * area of all (scaled) templates<br>
	 * C type : Numaa*
	 */
	public net.sourceforge.lept4j.Numaa.ByReference naasum;
	/**
	 * averaged unscaled templates per class<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixa_u;
	/**
	 * centroids of unscaled ave. templates<br>
	 * C type : Pta*
	 */
	public net.sourceforge.lept4j.Pta.ByReference pta_u;
	/**
	 * area of unscaled averaged templates<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference nasum_u;
	/**
	 * averaged (scaled) templates per class<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixa;
	/**
	 * centroids of (scaled) ave. templates<br>
	 * C type : Pta*
	 */
	public net.sourceforge.lept4j.Pta.ByReference pta;
	/**
	 * area of (scaled) averaged templates<br>
	 * C type : Numa*
	 */
	public net.sourceforge.lept4j.Numa.ByReference nasum;
	/**
	 * all input training images<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixa_tr;
	/**
	 * unscaled and scaled averaged bitmaps<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixadb_ave;
	/**
	 * input images for identifying<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixa_id;
	/**
	 * debug: best match of input against ave.<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixdb_ave;
	/**
	 * debug: best matches within range<br>
	 * C type : Pix*
	 */
	public net.sourceforge.lept4j.Pix.ByReference pixdb_range;
	/**
	 * debug: bootstrap training results<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixadb_boot;
	/**
	 * debug: splitting results<br>
	 * C type : Pixa*
	 */
	public net.sourceforge.lept4j.Pixa.ByReference pixadb_split;
	/**
	 * bmf fonts<br>
	 * C type : L_Bmf*
	 */
	public net.sourceforge.lept4j.L_Bmf.ByReference bmf;
	/**
	 * font size of bmf; default is 6 pt<br>
	 * C type : l_int32
	 */
	public int bmf_size;
	/**
	 * temp data used for image decoding<br>
	 * C type : L_Rdid*
	 */
	public net.sourceforge.lept4j.L_Rdid.ByReference did;
	/**
	 * temp data used for holding best char<br>
	 * C type : L_Rch*
	 */
	public net.sourceforge.lept4j.L_Rch.ByReference rch;
	/**
	 * temp data used for array of best chars<br>
	 * C type : L_Rcha*
	 */
	public net.sourceforge.lept4j.L_Rcha.ByReference rcha;
	public L_Recog() {
		super();
	}
	protected List<? > getFieldOrder() {
		return Arrays.asList("scalew", "scaleh", "linew", "templ_use", "maxarraysize", "setsize", "threshold", "maxyshift", "charset_type", "charset_size", "min_nopad", "num_samples", "minwidth_u", "maxwidth_u", "minheight_u", "maxheight_u", "minwidth", "maxwidth", "ave_done", "train_done", "max_wh_ratio", "max_ht_ratio", "min_splitw", "max_splith", "sa_text", "dna_tochar", "centtab", "sumtab", "pixaa_u", "ptaa_u", "naasum_u", "pixaa", "ptaa", "naasum", "pixa_u", "pta_u", "nasum_u", "pixa", "pta", "nasum", "pixa_tr", "pixadb_ave", "pixa_id", "pixdb_ave", "pixdb_range", "pixadb_boot", "pixadb_split", "bmf", "bmf_size", "did", "rch", "rcha");
	}
	public L_Recog(Pointer peer) {
		super(peer);
                read();
	}
	public static class ByReference extends L_Recog implements Structure.ByReference {
		
	};
	public static class ByValue extends L_Recog implements Structure.ByValue {
		
	};
}
