/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskEntity task = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("No task found for taskId '" + this.taskId + "'", Task.class);
        }
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            if (taskFormHandler == null) {
                throw new ActivitiException("No taskFormHandler specified for task '" + this.taskId + "'");
            }
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

