/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.engine.impl.transformer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Transforms a {@link Date} to a {@link String}
 * 
 * @author Esteban Robles Luna
 */
public class DateToString extends AbstractTransformer {

  protected DateFormat format = new SimpleDateFormat("dd/MM/yyyy");
  
  /**
   * {@inheritDoc}
   */
  @Override
  protected Object primTransform(Object anObject) throws Exception {
    return format.format((Date) anObject);
  }
}
