/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.install.internal;

import java.util.Collection;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.transfer.artifact.install.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.install.internal.MavenArtifactInstaller;
import org.apache.maven.shared.transfer.metadata.ArtifactMetadata;
import org.apache.maven.shared.transfer.metadata.internal.Maven31MetadataBridge;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;

class Maven31ArtifactInstaller
implements MavenArtifactInstaller {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    Maven31ArtifactInstaller(RepositorySystem repositorySystem, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.session = session;
    }

    @Override
    public void install(Collection<org.apache.maven.artifact.Artifact> mavenArtifacts) throws ArtifactInstallerException {
        InstallRequest request = new InstallRequest();
        for (org.apache.maven.artifact.Artifact mavenArtifact : mavenArtifacts) {
            Artifact mainArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, mavenArtifact);
            request.addArtifact(mainArtifact);
            for (org.apache.maven.artifact.metadata.ArtifactMetadata metadata : mavenArtifact.getMetadataList()) {
                if (metadata instanceof ProjectArtifactMetadata) {
                    SubArtifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                    pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                    request.addArtifact((Artifact)pomArtifact);
                    continue;
                }
                if (metadata instanceof ArtifactRepositoryMetadata || !(metadata instanceof ArtifactMetadata)) continue;
                ArtifactMetadata transferMetadata = (ArtifactMetadata)metadata;
                request.addMetadata(new Maven31MetadataBridge(metadata).setFile(transferMetadata.getFile()));
            }
        }
        try {
            this.repositorySystem.install(this.session, request);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallerException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

