/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.metadata.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.Builder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class GeodeticObjectBuilder
extends Builder<GeodeticObjectBuilder> {
    private String conversionName;
    private OperationMethod method;
    private ParameterValueGroup parameters;
    private CRSFactory crsFactory;
    private CSFactory csFactory;
    private DatumFactory datumFactory;
    private DefaultCoordinateOperationFactory copFactory;

    private CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = (CRSFactory)DefaultFactories.forBuildin(CRSFactory.class);
        }
        return this.crsFactory;
    }

    private CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = (CSFactory)DefaultFactories.forBuildin(CSFactory.class);
        }
        return this.csFactory;
    }

    private DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = (DatumFactory)DefaultFactories.forBuildin(DatumFactory.class);
        }
        return this.datumFactory;
    }

    private DefaultCoordinateOperationFactory getCoordinateOperationFactory() {
        if (this.copFactory == null) {
            this.copFactory = CoordinateOperations.factory();
        }
        return this.copFactory;
    }

    public GeodeticObjectBuilder setConversionMethod(String string) throws FactoryException {
        if (this.method != null) {
            throw new IllegalStateException(Errors.format((short)27, (Object)"OperationMethod"));
        }
        this.method = this.getCoordinateOperationFactory().getOperationMethod(string);
        this.parameters = this.method.getParameters().createValue();
        return this;
    }

    public GeodeticObjectBuilder setConversionName(String string) {
        this.conversionName = string;
        return this;
    }

    private void ensureConversionMethodSet() {
        if (this.parameters == null) {
            throw new IllegalStateException();
        }
    }

    public GeodeticObjectBuilder setParameter(String string, double d, Unit<?> unit) throws IllegalStateException, ParameterNotFoundException, InvalidParameterValueException {
        this.ensureConversionMethodSet();
        this.parameters.parameter(string).setValue(d, unit);
        return this;
    }

    public GeodeticObjectBuilder setTransverseMercator(TransverseMercator.Zoner zoner, double d, double d2) throws FactoryException {
        ArgumentChecks.ensureBetween((String)"latitude", (double)-90.0, (double)90.0, (double)d);
        ArgumentChecks.ensureBetween((String)"longitude", (double)-4.052915431398935E8, (double)4.052915431398935E8, (double)d2);
        this.setConversionMethod("Transverse Mercator");
        this.setConversionName(zoner.setParameters(this.parameters, d, d2));
        return this;
    }

    public GeodeticObjectBuilder setPolarStereographic(boolean bl) throws FactoryException {
        this.setConversionMethod("Polar Stereographic (variant A)");
        this.setConversionName(PolarStereographicA.setParameters(this.parameters, bl));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, CartesianCS cartesianCS) throws FactoryException {
        this.ensureConversionMethodSet();
        this.onCreate(false);
        try {
            String string = this.conversionName != null ? this.properties.put("name", this.conversionName) : null;
            Object v = this.properties.put("alias", null);
            Object v2 = this.properties.put("identifiers", null);
            Conversion conversion = this.getCoordinateOperationFactory().createDefiningConversion(this.properties, this.method, this.parameters);
            this.properties.put("identifiers", v2);
            this.properties.put("alias", v);
            if (string != null) {
                this.properties.put("name", string);
            }
            ProjectedCRS projectedCRS = this.getCRSFactory().createProjectedCRS(this.properties, geographicCRS, conversion, cartesianCS);
            return projectedCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(Date date, Unit<Time> unit) throws FactoryException {
        TimeCS timeCS = null;
        TemporalDatum temporalDatum = null;
        for (CommonCRS.Temporal temporal : CommonCRS.Temporal.values()) {
            TimeCS timeCS2;
            TemporalDatum temporalDatum2;
            if (temporalDatum == null && date.equals((temporalDatum2 = temporal.datum()).getOrigin())) {
                temporalDatum = temporalDatum2;
            }
            if (timeCS != null || !unit.equals((Object)(timeCS2 = (temporalDatum2 = temporal.crs()).getCoordinateSystem()).getAxis(0).getUnit())) continue;
            if (temporalDatum == timeCS2 && this.properties.isEmpty()) {
                return temporalDatum2;
            }
            timeCS = timeCS2;
        }
        this.onCreate(false);
        try {
            if (timeCS == null) {
                CSFactory cSFactory = this.getCSFactory();
                timeCS = CommonCRS.Temporal.JAVA.crs().getCoordinateSystem();
                timeCS = cSFactory.createTimeCS(GeodeticObjectBuilder.name((IdentifiedObject)timeCS), cSFactory.createCoordinateSystemAxis(GeodeticObjectBuilder.name((IdentifiedObject)timeCS.getAxis(0)), "t", AxisDirection.FUTURE, unit));
            }
            if (this.properties.get("name") == null) {
                this.properties.putAll(GeodeticObjectBuilder.name((IdentifiedObject)timeCS));
            }
            if (temporalDatum == null) {
                Object v = this.properties.remove("remarks");
                Object v2 = this.properties.remove("identifiers");
                temporalDatum = this.getDatumFactory().createTemporalDatum(this.properties, date);
                this.properties.put("identifiers", v2);
                this.properties.put("remarks", v);
                this.properties.put("name", temporalDatum.getName());
            }
            TemporalCRS temporalCRS = this.getCRSFactory().createTemporalCRS(this.properties, temporalDatum, timeCS);
            return temporalCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        return new EllipsoidalHeightCombiner(){

            public void initialize(int n) {
                if ((n & 1) != 0) {
                    this.crsFactory = GeodeticObjectBuilder.this.getCRSFactory();
                }
                if ((n & 2) != 0) {
                    this.csFactory = GeodeticObjectBuilder.this.getCSFactory();
                }
                if ((n & 4) != 0) {
                    this.opFactory = GeodeticObjectBuilder.this.getCoordinateOperationFactory();
                }
            }
        }.createCompoundCRS(this.properties, coordinateReferenceSystemArray);
    }

    private static Map<String, Object> name(IdentifiedObject identifiedObject) {
        return Collections.singletonMap("name", identifiedObject.getName());
    }
}

