/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import javax.measure.Quantity;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.math.DecimalFunctions;

final class DatumShiftGridCompressed<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = 4847888093457104917L;
    private final int ymax = this.getGridSize()[1] - 2;
    private final double[] averages;
    private final short[][] data;
    private final double scale;

    private DatumShiftGridCompressed(DatumShiftGridFile<C, T> datumShiftGridFile, double[] dArray, short[][] sArray, double d) {
        super(datumShiftGridFile);
        this.averages = dArray;
        this.data = sArray;
        this.scale = d;
    }

    static <C extends Quantity<C>, T extends Quantity<T>> DatumShiftGridFile<C, T> compress(DatumShiftGridFile.Float<C, T> float_, double[] dArray, double d) {
        boolean bl;
        short[][] sArrayArray = new short[float_.offsets.length][];
        boolean bl2 = bl = dArray == null;
        if (bl) {
            dArray = new double[sArrayArray.length];
        }
        for (int i = 0; i < sArrayArray.length; ++i) {
            double d2;
            if (bl) {
                d2 = Math.rint(float_.getCellMean(i) / d);
                dArray[i] = d2 * d;
            } else {
                d2 = dArray[i] / d;
            }
            float[] fArray = float_.offsets[i];
            short[] sArray = new short[fArray.length];
            for (int j = 0; j < fArray.length; ++j) {
                double d3 = DecimalFunctions.floatToDouble((float)fArray[j]);
                float f = Math.ulp((float)(d3 /= d));
                d3 -= d2;
                if (Math.abs(d3 -= (double)(sArray[j] = (short)Math.round(d3))) < (double)f) continue;
                return float_;
            }
            sArrayArray[i] = sArray;
        }
        return new DatumShiftGridCompressed<C, T>(float_, dArray, sArrayArray, d);
    }

    @Override
    protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
        return new DatumShiftGridCompressed<C, T>(this, this.averages, (short[][])objectArray, this.scale);
    }

    @Override
    public double getCellPrecision() {
        return Math.min(super.getCellPrecision(), 5.0 * this.scale);
    }

    @Override
    protected final Object[] getData() {
        return this.data;
    }

    @Override
    public final int getTranslationDimensions() {
        return this.data.length;
    }

    @Override
    public double getCellMean(int n) {
        return this.averages[n];
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        return (double)this.data[n][n2 + n3 * this.nx] * this.scale + this.averages[n];
    }

    @Override
    public void interpolateInCell(double d, double d2, double[] dArray) {
        int n = (int)d;
        d -= (double)n;
        int n2 = (int)d2;
        d2 -= (double)n2;
        if (n < 0) {
            n = 0;
            d = -1.0;
        } else if (n >= this.nx - 1) {
            n = this.nx - 2;
            d = 1.0;
        }
        if (n2 < 0) {
            n2 = 0;
            d2 = -1.0;
        } else if (n2 > this.ymax) {
            n2 = this.ymax;
            d2 = 1.0;
        }
        int n3 = this.nx * n2 + n;
        int n4 = this.nx + n3;
        for (int i = 0; i < this.data.length; ++i) {
            short[] sArray = this.data[i];
            double d3 = sArray[n3];
            double d4 = sArray[n4];
            d3 += d * ((double)sArray[n3 + 1] - d3);
            d4 += d * ((double)sArray[n4 + 1] - d4);
            dArray[i] = (d2 * (d4 - d3) + d3) * this.scale + this.averages[i];
        }
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            DatumShiftGridCompressed datumShiftGridCompressed = (DatumShiftGridCompressed)object;
            return Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(datumShiftGridCompressed.scale) && Arrays.equals(this.averages, datumShiftGridCompressed.averages);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.averages);
    }
}

