/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.GeographicRedimension;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic3Dto2D
extends GeographicRedimension {
    private static final long serialVersionUID = -9103595336196565505L;
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)Geographic3Dto2D.builder().addIdentifier("9659")).addName("Geographic3D to 2D conversion")).createGroup(new GeneralParameterDescriptor[0]);
    private transient MathTransform transform;

    public Geographic3Dto2D() {
        this(new GeodeticOperation[4]);
        this.redimensioned[0] = new GeographicRedimension(2, this.redimensioned);
        this.redimensioned[1] = new Geographic2Dto3D(this.redimensioned);
        this.redimensioned[2] = this;
        this.redimensioned[3] = new GeographicRedimension(3, this.redimensioned);
    }

    private Geographic3Dto2D(GeodeticOperation[] geodeticOperationArray) {
        super(3, 2, PARAMETERS, geodeticOperationArray);
    }

    @Override
    public synchronized MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        if (this.transform == null) {
            try {
                MatrixSIS matrixSIS = Matrices.createDiagonal(4, 3);
                matrixSIS.setElement(2, 2, 0.0);
                matrixSIS.setElement(3, 2, 1.0);
                this.transform = MathTransforms.linear(matrixSIS).inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new FactoryException((Throwable)noninvertibleTransformException);
            }
        }
        return this.transform;
    }

    public static final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        public WKT(boolean bl) {
            this.inverse = bl;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return PARAMETERS.createValue();
        }

        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.append((FormattableObject)new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(this.getParameterValues(), formatter);
            return "Param_MT";
        }
    }
}

