/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractStereographic;
import org.apache.sis.internal.referencing.provider.LambertConformal1SP;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.ObliqueStereographic;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlTransient
public final class PolarStereographicA
extends AbstractStereographic {
    private static final long serialVersionUID = 538262714055500925L;
    public static final String NAME = "Polar Stereographic (variant A)";
    public static final String IDENTIFIER = "9810";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = LambertConformal1SP.LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    private static final ParameterDescriptorGroup PARAMETERS;
    public static final int UPS_SHIFT = 2000000;

    public PolarStereographicA() {
        super(PARAMETERS);
    }

    public static String setParameters(ParameterValueGroup parameterValueGroup, boolean bl) {
        parameterValueGroup.parameter("latitude_of_origin").setValue(bl ? 90.0 : -90.0, Units.DEGREE);
        parameterValueGroup.parameter("central_meridian").setValue(0.0, Units.DEGREE);
        parameterValueGroup.parameter("scale_factor").setValue(0.994, Units.UNITY);
        parameterValueGroup.parameter("false_easting").setValue(2000000.0, Units.METRE);
        parameterValueGroup.parameter("false_northing").setValue(2000000.0, Units.METRE);
        return "Universal Polar Stereographic " + (bl ? "North" : "South");
    }

    public static int isUPS(ParameterValueGroup parameterValueGroup) {
        if (Numerics.epsilonEqual((double)parameterValueGroup.parameter("scale_factor").doubleValue(Units.UNITY), (double)0.994, (double)1.0E-13) && Numerics.epsilonEqual((double)parameterValueGroup.parameter("false_easting").doubleValue(Units.METRE), (double)2000000.0, (double)0.01) && Numerics.epsilonEqual((double)parameterValueGroup.parameter("false_northing").doubleValue(Units.METRE), (double)2000000.0, (double)0.01) && Numerics.epsilonEqual((double)parameterValueGroup.parameter("central_meridian").doubleValue(Units.DEGREE), (double)0.0, (double)8.999280057595393E-8)) {
            double d = parameterValueGroup.parameter("latitude_of_origin").doubleValue(Units.DEGREE);
            if (Numerics.epsilonEqual((double)d, (double)90.0, (double)8.999280057595393E-8)) {
                return 1;
            }
            if (Numerics.epsilonEqual((double)d, (double)-90.0, (double)8.999280057595393E-8)) {
                return -1;
            }
        }
        return 0;
    }

    static {
        SCALE_FACTOR = Mercator1SP.SCALE_FACTOR;
        ParameterBuilder parameterBuilder = PolarStereographicA.builder();
        LONGITUDE_OF_ORIGIN = PolarStereographicA.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)ObliqueStereographic.LONGITUDE_OF_ORIGIN)).reidentify((Citation)Citations.GEOTIFF, "3095")).rename((Citation)Citations.GEOTIFF, "StraightVertPoleLong"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier(IDENTIFIER)).addName(NAME)).addName((Citation)Citations.OGC, "Polar_Stereographic")).addName((Citation)Citations.GEOTIFF, "CT_PolarStereographic")).addName((Citation)Citations.PROJ4, "stere")).addIdentifier((Citation)Citations.GEOTIFF, "15")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

