/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;

class MatrixParameters
extends TensorParameters<Double> {
    private static final long serialVersionUID = 8452879524565700115L;

    MatrixParameters(ParameterDescriptor<Integer> parameterDescriptor, ParameterDescriptor<Integer> parameterDescriptor2) {
        super(Double.class, "elt_", "_", parameterDescriptor, parameterDescriptor2);
    }

    static boolean isEPSG(int[] nArray) {
        return nArray[0] < 2 && nArray[1] <= 2;
    }

    static String indicesToAlias(int[] nArray) {
        int n;
        int n2 = nArray[0];
        if (n2 >= 0 && n2 < 26 && (n = nArray[1]) >= 0 && n < 10) {
            return String.valueOf(new char[]{(char)(65 + n2), (char)(48 + n)});
        }
        return null;
    }

    static int[] aliasToIndices(String string) {
        int n;
        int n2;
        if (string.length() == 2 && (n2 = string.charAt(0) - 65) >= 0 && n2 < 26 && (n = string.charAt(1) - 48) >= 0 && n < 10) {
            return new int[]{n2, n};
        }
        return null;
    }

    @Override
    protected int[] nameToIndices(String string) throws IllegalArgumentException {
        int[] nArray = MatrixParameters.aliasToIndices(string);
        if (nArray == null) {
            nArray = super.nameToIndices(string);
        }
        return nArray;
    }

    @Override
    protected ParameterDescriptor<Double> createElementDescriptor(int[] nArray) throws IllegalArgumentException {
        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(4);
        hashMap.put("name", new NamedIdentifier((Citation)Citations.OGC, "OGC", this.indicesToName(nArray), null, null));
        String string = MatrixParameters.indicesToAlias(nArray);
        if (string != null) {
            hashMap.put("alias", new NamedIdentifier(Citations.SIS, "SIS", string, null, null));
        }
        return new DefaultParameterDescriptor<Double>((Map<String, ?>)hashMap, 0, 1, Double.class, null, null, (Double)this.getDefaultValue(nArray));
    }

    Object readResolve() throws ObjectStreamException {
        return this.equals(WKT1) ? WKT1 : this;
    }
}

