/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlTransient
public class DefaultCompoundCS
extends AbstractCS {
    private static final long serialVersionUID = -5726410275278843373L;
    private final List<CoordinateSystem> components;

    public DefaultCompoundCS(Map<String, ?> map, CoordinateSystem ... coordinateSystemArray) {
        coordinateSystemArray = DefaultCompoundCS.clone(coordinateSystemArray);
        super(map, DefaultCompoundCS.getAxes(coordinateSystemArray));
        this.components = UnmodifiableArrayList.wrap((Object[])coordinateSystemArray);
    }

    public DefaultCompoundCS(CoordinateSystem ... coordinateSystemArray) {
        coordinateSystemArray = DefaultCompoundCS.clone(coordinateSystemArray);
        this(coordinateSystemArray, DefaultCompoundCS.getAxes(coordinateSystemArray));
    }

    private DefaultCompoundCS(CoordinateSystem[] coordinateSystemArray, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(Collections.singletonMap("name", AxisDirections.appendTo((StringBuilder)new StringBuilder(60).append("Compound CS"), (CoordinateSystemAxis[])coordinateSystemAxisArray)), coordinateSystemAxisArray);
        this.components = UnmodifiableArrayList.wrap((Object[])coordinateSystemArray);
    }

    private static CoordinateSystem[] clone(CoordinateSystem[] coordinateSystemArray) {
        ArgumentChecks.ensureNonNull((String)"components", (Object)coordinateSystemArray);
        coordinateSystemArray = (CoordinateSystem[])coordinateSystemArray.clone();
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)coordinateSystemArray[i]);
        }
        return coordinateSystemArray;
    }

    private static CoordinateSystemAxis[] getAxes(CoordinateSystem[] coordinateSystemArray) {
        int n = 0;
        for (int i = 0; i < coordinateSystemArray.length; ++i) {
            n += coordinateSystemArray[i].getDimension();
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        n = 0;
        for (CoordinateSystem coordinateSystem : coordinateSystemArray) {
            int n2 = coordinateSystem.getDimension();
            for (int i = 0; i < n2; ++i) {
                coordinateSystemAxisArray[n++] = coordinateSystem.getAxis(i);
            }
        }
        assert (n == coordinateSystemAxisArray.length);
        return coordinateSystemAxisArray;
    }

    public List<CoordinateSystem> getComponents() {
        return this.components;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (!(object instanceof DefaultCompoundCS) || !super.equals(object, comparisonMode)) {
            return false;
        }
        return Utilities.deepEquals(this.components, ((DefaultCompoundCS)object).components, (ComparisonMode)comparisonMode);
    }
}

