/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class DatumShiftGrid<C extends Quantity<C>, T extends Quantity<T>>
implements Serializable {
    private static final long serialVersionUID = 8405276545243175808L;
    private final Unit<C> coordinateUnit;
    private final LinearTransform coordinateToGrid;
    private final Unit<T> translationUnit;
    private final boolean isCellValueRatio;
    private final int[] gridSize;
    private transient double scaleX;
    private transient double scaleY;
    private transient double x0;
    private transient double y0;

    protected DatumShiftGrid(Unit<C> unit, LinearTransform linearTransform, int[] nArray, boolean bl, Unit<T> unit2) {
        ArgumentChecks.ensureNonNull((String)"coordinateUnit", unit);
        ArgumentChecks.ensureNonNull((String)"coordinateToGrid", (Object)linearTransform);
        ArgumentChecks.ensureNonNull((String)"gridSize", (Object)nArray);
        ArgumentChecks.ensureNonNull((String)"translationUnit", unit2);
        int n = linearTransform.getTargetDimensions();
        if (n != nArray.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, (Object)"gridSize", (Object)n, (Object)nArray.length));
        }
        this.coordinateUnit = unit;
        this.coordinateToGrid = linearTransform;
        this.isCellValueRatio = bl;
        this.translationUnit = unit2;
        nArray = (int[])nArray.clone();
        this.gridSize = nArray;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n >= 2) continue;
            throw new IllegalArgumentException(Errors.format((short)(n <= 0 ? (short)165 : 45), (Object)("gridSize[" + i + ']'), (Object)n));
        }
        this.computeConversionFactors();
    }

    private void computeConversionFactors() {
        Matrix matrix;
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        double d = Units.toStandardUnit(this.coordinateUnit);
        if (!Double.isNaN(d) && Matrices.isAffine(matrix = this.coordinateToGrid.getMatrix())) {
            int n = matrix.getNumCol() - 1;
            switch (matrix.getNumRow()) {
                default: {
                    this.y0 = matrix.getElement(1, n);
                    this.scaleY = DatumShiftGrid.diagonal(matrix, 1, n) / d;
                }
                case 1: {
                    this.x0 = matrix.getElement(0, n);
                    this.scaleX = DatumShiftGrid.diagonal(matrix, 0, n) / d;
                }
                case 0: 
            }
        }
    }

    private static double diagonal(Matrix matrix, int n, int n2) {
        while (--n2 >= 0) {
            if (n == n2 || matrix.getElement(n, n2) == 0.0) continue;
            return Double.NaN;
        }
        return matrix.getElement(n, n);
    }

    protected DatumShiftGrid(DatumShiftGrid<C, T> datumShiftGrid) {
        ArgumentChecks.ensureNonNull((String)"other", datumShiftGrid);
        this.coordinateUnit = datumShiftGrid.coordinateUnit;
        this.coordinateToGrid = datumShiftGrid.coordinateToGrid;
        this.isCellValueRatio = datumShiftGrid.isCellValueRatio;
        this.translationUnit = datumShiftGrid.translationUnit;
        this.gridSize = datumShiftGrid.gridSize;
        this.scaleX = datumShiftGrid.scaleX;
        this.scaleY = datumShiftGrid.scaleY;
        this.x0 = datumShiftGrid.x0;
        this.y0 = datumShiftGrid.y0;
    }

    public int[] getGridSize() {
        return (int[])this.gridSize.clone();
    }

    public Envelope getDomainOfValidity() throws TransformException {
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.gridSize.length);
        for (int i = 0; i < this.gridSize.length; ++i) {
            generalEnvelope.setRange(i, -0.5, (double)this.gridSize[i] - 0.5);
        }
        return Envelopes.transform(this.getCoordinateToGrid().inverse(), (Envelope)generalEnvelope);
    }

    public Unit<C> getCoordinateUnit() {
        return this.coordinateUnit;
    }

    public LinearTransform getCoordinateToGrid() {
        return this.coordinateToGrid;
    }

    public final double normalizedToGridX(double d) {
        return d * this.scaleX + this.x0;
    }

    public final double normalizedToGridY(double d) {
        return d * this.scaleY + this.y0;
    }

    public abstract int getTranslationDimensions();

    public Unit<T> getTranslationUnit() {
        return this.translationUnit;
    }

    public double[] interpolateAt(double ... dArray) throws TransformException {
        LinearTransform linearTransform = this.getCoordinateToGrid();
        ArgumentChecks.ensureDimensionMatches((String)"ordinates", (int)linearTransform.getSourceDimensions(), (double[])dArray);
        int n = this.getTranslationDimensions();
        double[] dArray2 = new double[Math.max(n, linearTransform.getTargetDimensions())];
        linearTransform.transform(dArray, 0, dArray2, 0, 1);
        this.interpolateInCell(dArray2[0], dArray2[1], dArray2);
        if (this.isCellValueRatio()) {
            linearTransform.inverse().deltaTransform(dArray2, 0, dArray2, 0, 1);
        }
        if (dArray2.length != n) {
            dArray2 = Arrays.copyOf(dArray2, n);
        }
        return dArray2;
    }

    public void interpolateInCell(double d, double d2, double[] dArray) {
        int n;
        int n2 = (int)d;
        d -= (double)n2;
        int n3 = (int)d2;
        d2 -= (double)n3;
        if (n2 < 0) {
            n2 = 0;
            d = -1.0;
        } else {
            n = this.gridSize[0] - 2;
            if (n2 > n) {
                n2 = n;
                d = 1.0;
            }
        }
        if (n3 < 0) {
            n3 = 0;
            d2 = -1.0;
        } else {
            n = this.gridSize[1] - 2;
            if (n3 > n) {
                n3 = n;
                d2 = 1.0;
            }
        }
        n = this.getTranslationDimensions();
        for (int i = 0; i < n; ++i) {
            double d3 = this.getCellValue(i, n2, n3);
            double d4 = this.getCellValue(i, n2, n3 + 1);
            d3 += d * (this.getCellValue(i, n2 + 1, n3) - d3);
            d4 += d * (this.getCellValue(i, n2 + 1, n3 + 1) - d4);
            dArray[i] = d2 * (d4 - d3) + d3;
        }
    }

    public Matrix derivativeInCell(double d, double d2) {
        int n = Math.max(0, Math.min(this.gridSize[0] - 2, (int)d));
        int n2 = Math.max(0, Math.min(this.gridSize[1] - 2, (int)d2));
        MatrixSIS matrixSIS = Matrices.createDiagonal(this.getTranslationDimensions(), this.gridSize.length);
        int n3 = matrixSIS.getNumRow();
        while (--n3 >= 0) {
            double d3 = this.getCellValue(n3, n2, n);
            matrixSIS.setElement(n3, 0, matrixSIS.getElement(n3, 0) + (this.getCellValue(n3, n2 + 1, n) - d3));
            matrixSIS.setElement(n3, 1, matrixSIS.getElement(n3, 1) + (this.getCellValue(n3, n2, n + 1) - d3));
        }
        return matrixSIS;
    }

    public abstract double getCellValue(int var1, int var2, int var3);

    public double getCellMean(int n) {
        DoubleDouble doubleDouble = new DoubleDouble();
        int n2 = this.gridSize[0];
        int n3 = this.gridSize[1];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleDouble.add(this.getCellValue(n, j, i));
            }
        }
        return doubleDouble.value / (double)(n2 * n3);
    }

    public abstract double getCellPrecision();

    public boolean isCellValueRatio() {
        return this.isCellValueRatio;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DatumShiftGrid datumShiftGrid = (DatumShiftGrid)object;
            return Arrays.equals(this.gridSize, datumShiftGrid.gridSize) && Objects.equals(this.coordinateToGrid, datumShiftGrid.coordinateToGrid) && Objects.equals(this.coordinateUnit, datumShiftGrid.coordinateUnit) && Objects.equals(this.translationUnit, datumShiftGrid.translationUnit) && this.isCellValueRatio == datumShiftGrid.isCellValueRatio;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.coordinateToGrid) + 37 * Arrays.hashCode(this.gridSize);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeConversionFactors();
    }
}

