/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private static final BursaWolfParameters[] EMPTY_ARRAY = new BursaWolfParameters[0];
    private Ellipsoid ellipsoid;
    private PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"ellipsoid", (Object)ellipsoid);
        ArgumentChecks.ensureNonNull((String)"primeMeridian", (Object)primeMeridian);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        this.bursaWolf = (BursaWolfParameters[])CollectionsExt.nonEmpty((Object[])CollectionsExt.nonNullArraySet((String)BURSA_WOLF_KEY, map.get(BURSA_WOLF_KEY), (Object[])EMPTY_ARRAY));
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                ArgumentChecks.ensureNonNullElement((String)BURSA_WOLF_KEY, (int)i, (Object)bursaWolfParameters);
                bursaWolfParameters = bursaWolfParameters.clone();
                bursaWolfParameters.verify(primeMeridian);
                this.bursaWolf[i] = bursaWolfParameters;
            }
        }
    }

    protected DefaultGeodeticDatum(GeodeticDatum geodeticDatum) {
        super((Datum)geodeticDatum);
        this.ellipsoid = geodeticDatum.getEllipsoid();
        this.primeMeridian = geodeticDatum.getPrimeMeridian();
        this.bursaWolf = geodeticDatum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)geodeticDatum).bursaWolf : null;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum geodeticDatum) {
        return geodeticDatum == null || geodeticDatum instanceof DefaultGeodeticDatum ? (DefaultGeodeticDatum)geodeticDatum : new DefaultGeodeticDatum(geodeticDatum);
    }

    public Class<? extends GeodeticDatum> getInterface() {
        return GeodeticDatum.class;
    }

    @XmlElement(name="ellipsoid", required=true)
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @XmlElement(name="primeMeridian", required=true)
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf == null) {
            return EMPTY_ARRAY;
        }
        BursaWolfParameters[] bursaWolfParametersArray = (BursaWolfParameters[])this.bursaWolf.clone();
        for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
            bursaWolfParametersArray[i] = bursaWolfParametersArray[i].clone();
        }
        return bursaWolfParametersArray;
    }

    public Matrix getPositionVectorTransformation(GeodeticDatum geodeticDatum, Extent extent) {
        ArgumentChecks.ensureNonNull((String)"targetDatum", (Object)geodeticDatum);
        ExtentSelector<BursaWolfParameters> extentSelector = new ExtentSelector<BursaWolfParameters>(extent);
        BursaWolfParameters bursaWolfParameters = this.select(geodeticDatum, extentSelector);
        if (bursaWolfParameters != null) {
            return DefaultGeodeticDatum.createTransformation(bursaWolfParameters, extent);
        }
        if (geodeticDatum instanceof DefaultGeodeticDatum && (bursaWolfParameters = ((DefaultGeodeticDatum)geodeticDatum).select(this, extentSelector)) != null) {
            try {
                return Matrices.inverse(DefaultGeodeticDatum.createTransformation(bursaWolfParameters, extent));
            }
            catch (NoninvertibleMatrixException noninvertibleMatrixException) {
                Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.operation"), DefaultGeodeticDatum.class, (String)"getPositionVectorTransformation", (Throwable)((Object)noninvertibleMatrixException));
            }
        }
        return null;
    }

    private static Matrix createTransformation(BursaWolfParameters bursaWolfParameters, Extent extent) {
        return bursaWolfParameters.getPositionVectorTransformation(bursaWolfParameters.getClass() != BursaWolfParameters.class ? Extents.getDate((Extent)extent, (double)0.5) : null);
    }

    private BursaWolfParameters select(GeodeticDatum geodeticDatum, ExtentSelector<BursaWolfParameters> extentSelector) {
        if (this.bursaWolf == null) {
            return null;
        }
        for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
            if (!Utilities.deepEquals((Object)geodeticDatum, (Object)bursaWolfParameters.getTargetDatum(), (ComparisonMode)ComparisonMode.IGNORE_METADATA)) continue;
            extentSelector.evaluate(bursaWolfParameters.getDomainOfValidity(), bursaWolfParameters);
        }
        return extentSelector.best();
    }

    @Override
    public boolean isHeuristicMatchForName(String string) {
        final String string2 = this.primeMeridian.getName().getCode();
        return NameToIdentifier.isHeuristicMatchForName((Identifier)super.getName(), super.getAlias(), (CharSequence)string, (NameToIdentifier.Simplifier)new AbstractDatum.Simplifier(){

            @Override
            protected CharSequence apply(CharSequence charSequence) {
                int n;
                int n2 = CharSequences.indexOf((CharSequence)(charSequence = super.apply(charSequence)), (CharSequence)string2, (int)0, (int)charSequence.length()) - 1;
                if (n2 >= 0 && charSequence.charAt(n2) == '(' && (n = n2 + string2.length() + 1) < charSequence.length() && charSequence.charAt(n) == ')') {
                    int n3;
                    for (n2 = CharSequences.skipTrailingWhitespaces((CharSequence)charSequence, (int)0, (int)n2); n2 > 0; n2 -= Character.charCount(n3)) {
                        n3 = Character.codePointBefore(charSequence, n2);
                        if (!Character.isLetterOrDigit(n3)) continue;
                        charSequence = new StringBuilder(charSequence).delete(n2, n + 1).toString();
                        break;
                    }
                }
                return charSequence;
            }
        });
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultGeodeticDatum defaultGeodeticDatum = (DefaultGeodeticDatum)object;
                return Objects.equals(this.ellipsoid, defaultGeodeticDatum.ellipsoid) && Objects.equals(this.primeMeridian, defaultGeodeticDatum.primeMeridian) && Arrays.equals(this.bursaWolf, defaultGeodeticDatum.bursaWolf);
            }
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)object;
        return Utilities.deepEquals((Object)this.getEllipsoid(), (Object)geodeticDatum.getEllipsoid(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getPrimeMeridian(), (Object)geodeticDatum.getPrimeMeridian(), (ComparisonMode)comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.ellipsoid) + (long)(31 * Objects.hashCode(this.primeMeridian));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        super.formatTo(formatter);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getEllipsoid()));
        boolean bl2 = bl = formatter.getConvention().majorVersion() == 1;
        if (bl && this.bursaWolf != null) {
            for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
                if (!bursaWolfParameters.isToWGS84()) continue;
                formatter.newLine();
                formatter.append((FormattableObject)bursaWolfParameters);
                break;
            }
        }
        formatter.newLine();
        if (!bl && !(formatter.getEnclosingElement(1) instanceof GeodeticCRS)) {
            return formatter.shortOrLong("Datum", "GeodeticDatum");
        }
        return "Datum";
    }

    private DefaultGeodeticDatum() {
        this.bursaWolf = null;
    }

    private void setEllipsoid(Ellipsoid ellipsoid) {
        if (this.ellipsoid == null) {
            this.ellipsoid = ellipsoid;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultGeodeticDatum.class, (String)"setEllipsoid", (String)"ellipsoid");
        }
    }

    private void setPrimeMeridian(PrimeMeridian primeMeridian) {
        if (this.primeMeridian == null) {
            this.primeMeridian = primeMeridian;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultGeodeticDatum.class, (String)"setPrimeMeridian", (String)"primeMeridian");
        }
    }
}

