/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class SQLTranslator {
    private static final String[] SENTINEL = new String[]{"Coordinate Reference System", "coordinatereferencesystem", "epsg_coordinatereferencesystem"};
    private static final int MIXED_CASE = 0;
    static final String TABLE_PREFIX = "epsg_";
    private static final String[] BOOLEAN_FIELDS = new String[]{"SHOW_CRS", "SHOW_OPERATION", "DEPRECATED"};
    private String catalog;
    private String schema;
    private boolean isPrefixed;
    private final Map<String, String> accessToAnsi;
    private boolean quoteTableNames;
    private final String quote;
    private boolean useBoolean;
    private boolean isTableFound;

    public SQLTranslator(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ArgumentChecks.ensureNonNull((String)"md", (Object)databaseMetaData);
        this.quote = databaseMetaData.getIdentifierQuoteString().trim();
        this.accessToAnsi = new HashMap<String, String>(4);
        this.catalog = string;
        this.schema = string2;
        this.setup(databaseMetaData);
    }

    final void setup(DatabaseMetaData databaseMetaData) throws SQLException {
        Throwable throwable;
        Object object;
        Object object2;
        boolean bl = databaseMetaData.storesUpperCaseIdentifiers();
        int n = SENTINEL.length;
        while (--n >= 0) {
            object2 = SENTINEL[n];
            if (bl && n != 0) {
                object2 = ((String)object2).toUpperCase(Locale.US);
            }
            object = databaseMetaData.getTables(this.catalog, this.schema, (String)object2, null);
            throwable = null;
            try {
                if (!object.next()) continue;
                this.isTableFound = true;
                this.isPrefixed = ((String)object2).startsWith(TABLE_PREFIX);
                this.quoteTableNames = n == 0;
                do {
                    this.catalog = object.getString("TABLE_CAT");
                    this.schema = object.getString("TABLE_SCHEM");
                } while (!"EPSG".equalsIgnoreCase(this.schema) && object.next());
                if (this.schema != null) break;
                this.schema = "";
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object == null) continue;
                if (throwable != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                object.close();
            }
        }
        n = 1;
        this.accessToAnsi.clear();
        if (this.quoteTableNames) {
            object2 = databaseMetaData.getColumns(this.catalog, this.schema, "Coordinate Axis", "ORDER");
            object = null;
            try {
                n = !object2.next() ? 1 : 0;
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw throwable4;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        } else {
            this.accessToAnsi.put("Coordinate_Operation", "coordoperation");
            this.accessToAnsi.put("Parameter", "param");
        }
        if (n != 0) {
            this.accessToAnsi.put("ORDER", "coord_axis_order");
        }
        object2 = "DEPRECATED";
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            object2 = ((String)object2).toLowerCase(Locale.US);
        }
        object = databaseMetaData.getColumns(this.catalog, this.schema, null, (String)object2);
        throwable = null;
        try {
            while (object.next()) {
                if (!CharSequences.endsWith((CharSequence)object.getString("TABLE_NAME"), (CharSequence)"Datum", (boolean)true)) continue;
                int n2 = object.getInt("DATA_TYPE");
                this.useBoolean = n2 == 16 || n2 == -7;
                break;
            }
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    object.close();
                }
            }
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    final boolean isTableFound() {
        return this.isTableFound;
    }

    static String tableNotFound(Locale locale) {
        return Errors.getResources((Locale)locale).getString((short)126, (Object)SENTINEL[0]);
    }

    final boolean useBoolean() {
        return this.useBoolean;
    }

    private static String nonEmpty(String string) {
        return string != null && !string.isEmpty() ? string : null;
    }

    public String apply(String string) {
        int n;
        int n2;
        String string2 = SQLTranslator.nonEmpty(this.catalog);
        String string3 = SQLTranslator.nonEmpty(this.schema);
        if (this.quote.isEmpty() && this.accessToAnsi.isEmpty() && string3 == null && string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        int n3 = 0;
        while ((n2 = string.indexOf(91, n3)) >= 0) {
            String string4;
            stringBuilder.append(string, n3, n2);
            n3 = string.indexOf(93, ++n2);
            if (n3 < 0) {
                throw new IllegalArgumentException(Errors.format((short)84, (Object)string.substring(n2), (Object)Character.valueOf(']')));
            }
            if (CharSequences.isUpperCase((CharSequence)(string4 = string.substring(n2, n3++)))) {
                stringBuilder.append((String)JDK8.getOrDefault(this.accessToAnsi, (Object)string4, (Object)string4));
                continue;
            }
            if (string2 != null) {
                stringBuilder.append(this.quote).append(string2).append(this.quote).append('.');
            }
            if (string3 != null) {
                stringBuilder.append(this.quote).append(string3).append(this.quote).append('.');
            }
            if (this.quoteTableNames) {
                stringBuilder.append(this.quote);
            }
            if (this.isPrefixed) {
                stringBuilder.append(TABLE_PREFIX);
            }
            if (this.quoteTableNames) {
                stringBuilder.append((String)JDK8.getOrDefault(this.accessToAnsi, (Object)string4, (Object)string4)).append(this.quote);
                continue;
            }
            for (String string5 : string4.split("\\s")) {
                stringBuilder.append((String)JDK8.getOrDefault(this.accessToAnsi, (Object)string5, (Object)string5));
            }
        }
        stringBuilder.append(string, n3, string.length());
        if (this.useBoolean && (n = stringBuilder.indexOf("WHERE")) >= 0) {
            n += 5;
            for (String string5 : BOOLEAN_FIELDS) {
                int n4 = stringBuilder.indexOf(string5, n);
                if (n4 < 0 || SQLTranslator.replaceIfEquals(stringBuilder, n4 += string5.length(), "=0", "=FALSE") || SQLTranslator.replaceIfEquals(stringBuilder, n4, "<>0", "=TRUE") || (n4 = stringBuilder.lastIndexOf("(", n4)) <= n) continue;
                SQLTranslator.replaceIfEquals(stringBuilder, n4 - 3, "ABS", "");
            }
        }
        return stringBuilder.toString();
    }

    private static boolean replaceIfEquals(StringBuilder stringBuilder, int n, String string, String string2) {
        if (CharSequences.regionMatches((CharSequence)stringBuilder, (int)n, (CharSequence)string)) {
            stringBuilder.replace(n, n + string.length(), string2);
            return true;
        }
        return false;
    }
}

