/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LocalizationGridBuilder
extends TransformBuilder {
    private static final double EPS = 1.0E-13;
    private final LinearTransformBuilder linear;
    private final int[] tmp = new int[2];
    private LinearTransform sourceToGrid;
    private double precision;
    static final double DEFAULT_PRECISION = 1.0E-7;

    public LocalizationGridBuilder(int n, int n2) {
        this.linear = new LinearTransformBuilder(n, n2);
        this.sourceToGrid = MathTransforms.identity(2);
    }

    public LocalizationGridBuilder(Vector vector, Vector vector2) {
        MatrixSIS matrixSIS = Matrices.createDiagonal(3, 3);
        this.linear = new LinearTransformBuilder(LocalizationGridBuilder.infer(vector, matrixSIS, 0), LocalizationGridBuilder.infer(vector2, matrixSIS, 1));
        try {
            this.sourceToGrid = MathTransforms.linear(matrixSIS).inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw (ArithmeticException)new ArithmeticException(noninvertibleTransformException.getLocalizedMessage()).initCause(noninvertibleTransformException);
        }
    }

    private static int infer(Vector vector, Matrix matrix, int n) {
        double d;
        NumberRange numberRange = vector.range();
        double d2 = numberRange.getMinDouble(true);
        double d3 = numberRange.getMaxDouble(true) - d2;
        Number number = vector.increment(1.0E-13 * d3);
        if (number != null) {
            d = number.doubleValue();
        } else {
            d = d3;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                double d4;
                double d5 = vector.doubleValue(i) - d2;
                if (!(Math.abs(d5 % d) > 1.0E-13)) continue;
                do {
                    d4 = d % d5;
                    d = d5;
                } while (Math.abs(d5 = d4) > 1.0E-13);
            }
        }
        matrix.setElement(n, n, d);
        matrix.setElement(n, 2, d2);
        double d6 = d3 / d;
        if (d6 > 0.5 && d6 < 32767.5) {
            return (int)Math.round(d6) + 1;
        }
        throw new ArithmeticException(Resources.format((short)75, numberRange));
    }

    public void setDesiredPrecision(double d) {
        ArgumentChecks.ensureStrictlyPositive((String)"precision", (double)d);
        this.precision = d;
    }

    public double getDesiredPrecision() {
        return this.precision;
    }

    public void setSourceToGrid(LinearTransform linearTransform) {
        ArgumentChecks.ensureNonNull((String)"sourceToGrid", (Object)linearTransform);
        int n = 0;
        int n2 = linearTransform.getSourceDimensions();
        if (n2 >= 2) {
            n = 1;
            n2 = linearTransform.getTargetDimensions();
            if (n2 == 2) {
                this.sourceToGrid = linearTransform;
                return;
            }
        }
        throw new MismatchedDimensionException(Resources.format((short)37, n, 2, n2));
    }

    public LinearTransform getSourceToGrid() {
        return this.sourceToGrid;
    }

    public void setControlPoint(int n, int n2, double ... dArray) {
        this.tmp[0] = n;
        this.tmp[1] = n2;
        this.linear.setControlPoint(this.tmp, dArray);
    }

    public double[] getControlPoint(int n, int n2) {
        this.tmp[0] = n;
        this.tmp[1] = n2;
        return this.linear.getControlPoint(this.tmp);
    }

    @Override
    public MathTransform create(MathTransformFactory mathTransformFactory) throws FactoryException {
        LinearTransform linearTransform = this.linear.create(mathTransformFactory);
        boolean bl = true;
        boolean bl2 = true;
        for (double d : this.linear.correlation()) {
            bl &= d == 1.0;
            if (!(d < 0.9999)) continue;
            bl2 = false;
            break;
        }
        if (bl) {
            return MathTransforms.concatenate(this.sourceToGrid, linearTransform);
        }
        int n = this.linear.gridSize(0);
        int n2 = this.linear.gridSize(1);
        int n3 = linearTransform.getTargetDimensions();
        double[] dArray = new double[n3 * this.linear.gridLength];
        double[] dArray2 = new double[n3 + 1];
        double d = this.precision;
        try {
            int n4;
            Object object;
            Object object2;
            if (d > 0.0 && !this.sourceToGrid.isIdentity()) {
                object2 = new double[this.sourceToGrid.getSourceDimensions()];
                object = new double[this.sourceToGrid.getTargetDimensions()];
                double d2 = 0.0;
                for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                    object2[n4] = this.precision;
                    this.sourceToGrid.deltaTransform((double[])object2, 0, (double[])object, 0, 1);
                    double d3 = MathFunctions.magnitude((double[])object);
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    object2[n4] = 0.0;
                }
                d = d2;
            }
            object2 = MatrixSIS.castOrCopy(linearTransform.inverse().getMatrix());
            object = new DirectPosition2D();
            dArray2[n3] = 1.0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                ((DirectPosition2D)object).y = i;
                this.tmp[1] = i;
                for (n4 = 0; n4 < n; ++n4) {
                    ((DirectPosition2D)object).x = n4;
                    this.tmp[0] = n4;
                    this.linear.getControlPoint2D(this.tmp, dArray2);
                    double[] dArray3 = ((MatrixSIS)object2).multiply(dArray2);
                    int n6 = n5++;
                    double d4 = dArray3[0] - (double)n4;
                    dArray[n6] = d4;
                    bl2 &= d4 <= d;
                    int n7 = n5++;
                    double d5 = dArray3[1] - (double)i;
                    dArray[n7] = d5;
                    bl2 &= d5 <= d;
                }
            }
        }
        catch (TransformException transformException) {
            throw new FactoryException((Throwable)transformException);
        }
        if (bl2) {
            return MathTransforms.concatenate(this.sourceToGrid, linearTransform);
        }
        return InterpolatedTransform.createGeodeticTransformation(LocalizationGridBuilder.nonNull(mathTransformFactory), new ResidualGrid(this.sourceToGrid, linearTransform, n, n2, n3, dArray, d > 0.0 ? d : 1.0E-7));
    }
}

