/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.Map;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.operation.OperationMethod;

final class Initializer {
    final ContextualParameters context;
    final Parameters parameters;
    final DoubleDouble eccentricitySquared;
    final byte variant;
    static final byte AUTHALIC_RADIUS = -128;

    Initializer(OperationMethod operationMethod, Parameters parameters, Map<NormalizedProjection.ParameterRole, ? extends ParameterDescriptor<? extends Number>> map, byte by) {
        ParameterDescriptor<? extends Number> parameterDescriptor;
        Object object;
        ArgumentChecks.ensureNonNull((String)"method", (Object)operationMethod);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameters);
        ArgumentChecks.ensureNonNull((String)"roles", map);
        this.context = new ContextualParameters(operationMethod);
        this.parameters = parameters;
        this.variant = by;
        ParameterDescriptor<? extends Number> parameterDescriptor2 = map.get((Object)NormalizedProjection.ParameterRole.SEMI_MAJOR);
        ParameterDescriptor<? extends Number> parameterDescriptor3 = map.get((Object)NormalizedProjection.ParameterRole.SEMI_MINOR);
        if (parameterDescriptor2 == null) {
            parameterDescriptor2 = MapProjection.SEMI_MAJOR;
        }
        if (parameterDescriptor3 == null) {
            parameterDescriptor3 = MapProjection.SEMI_MINOR;
        }
        double d = this.getAndStore(parameterDescriptor2);
        double d2 = this.getAndStore(parameterDescriptor3);
        double d3 = this.getAndStore(map.get((Object)NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN));
        double d4 = this.getAndStore(map.get((Object)NormalizedProjection.ParameterRole.FALSE_EASTING)) - this.getAndStore(map.get((Object)NormalizedProjection.ParameterRole.FALSE_WESTING));
        double d5 = this.getAndStore(map.get((Object)NormalizedProjection.ParameterRole.FALSE_NORTHING)) - this.getAndStore(map.get((Object)NormalizedProjection.ParameterRole.FALSE_SOUTHING));
        this.eccentricitySquared = new DoubleDouble();
        DoubleDouble doubleDouble = new DoubleDouble(d);
        if (d != d2) {
            if (by == -128) {
                doubleDouble.value = Formulas.getAuthalicRadius(d, d2);
                doubleDouble.error = 0.0;
            } else {
                boolean bl;
                try {
                    bl = parameters.parameter("is_ivf_definitive").booleanValue();
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    bl = false;
                }
                if (bl) {
                    object = new DoubleDouble(parameters.parameter("inverse_flattening").doubleValue());
                    object.inverseDivide(1.0, 0.0);
                    this.eccentricitySquared.setFrom((DoubleDouble)object);
                    this.eccentricitySquared.multiply(2.0, 0.0);
                    object.square();
                    this.eccentricitySquared.subtract((DoubleDouble)object);
                } else {
                    object = new DoubleDouble(d2);
                    object.divide(doubleDouble);
                    object.square();
                    this.eccentricitySquared.value = 1.0;
                    this.eccentricitySquared.subtract((DoubleDouble)object);
                }
                object = map.get((Object)NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS);
                if (object != null) {
                    doubleDouble = this.r\u03bd2(Math.sin(Math.toRadians(parameters.doubleValue((ParameterDescriptor<? extends Number>)object))));
                    doubleDouble.inverseDivide(d2, 0.0);
                }
            }
        }
        if ((parameterDescriptor = map.get((Object)NormalizedProjection.ParameterRole.SCALE_FACTOR)) != null) {
            doubleDouble.multiply(this.getAndStore(parameterDescriptor));
        }
        this.context.normalizeGeographicInputs(d3);
        object = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        ((MatrixSIS)object).convertAfter(0, (Number)doubleDouble, (Number)new DoubleDouble(d4));
        ((MatrixSIS)object).convertAfter(1, (Number)doubleDouble, (Number)new DoubleDouble(d5));
    }

    final double getAndStore(ParameterDescriptor<? extends Number> parameterDescriptor) {
        if (parameterDescriptor == null) {
            return 0.0;
        }
        double d = this.parameters.doubleValue(parameterDescriptor);
        Number number = (Number)parameterDescriptor.getDefaultValue();
        if (number == null || !number.equals(d)) {
            MapProjection.validate(parameterDescriptor, d);
            this.context.getOrCreate(parameterDescriptor).setValue(d);
        }
        return d;
    }

    final double getAndStore(ParameterDescriptor<Double> parameterDescriptor, double d) {
        Double d2 = this.parameters.getValue(parameterDescriptor);
        if (d2 == null) {
            return d;
        }
        MapProjection.validate(parameterDescriptor, d2);
        this.context.getOrCreate(parameterDescriptor).setValue((Object)d2);
        return d2;
    }

    final DoubleDouble axisLengthRatio() {
        DoubleDouble doubleDouble = new DoubleDouble(1.0, 0.0);
        doubleDouble.subtract(this.eccentricitySquared);
        doubleDouble.sqrt();
        return doubleDouble;
    }

    private DoubleDouble r\u03bd2(double d) {
        DoubleDouble doubleDouble = DoubleDouble.verbatim((double)d);
        doubleDouble.square();
        doubleDouble.multiply(this.eccentricitySquared);
        doubleDouble.negate();
        doubleDouble.add(1.0, 0.0);
        return doubleDouble;
    }

    final double radiusOfConformalSphere(double d) {
        DoubleDouble doubleDouble = DoubleDouble.verbatim((double)1.0);
        doubleDouble.subtract(this.eccentricitySquared);
        doubleDouble.sqrt();
        doubleDouble.divide(this.r\u03bd2(d));
        return doubleDouble.value;
    }

    final double scaleAt\u03c6(double d, double d2) {
        DoubleDouble doubleDouble = this.r\u03bd2(d);
        doubleDouble.sqrt();
        doubleDouble.inverseDivide(d2, 0.0);
        return doubleDouble.value;
    }
}

