/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;

public abstract class DatumShiftTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4492222496475405226L;
    final ContextualParameters context;
    final DatumShiftGrid<?, ?> grid;

    DatumShiftTransform(ParameterDescriptorGroup parameterDescriptorGroup, DatumShiftGrid<?, ?> datumShiftGrid) {
        int n = datumShiftGrid.getTranslationDimensions() + 1;
        this.context = new ContextualParameters(parameterDescriptorGroup, n, n);
        this.grid = datumShiftGrid;
    }

    DatumShiftTransform(ParameterDescriptorGroup parameterDescriptorGroup, boolean bl, boolean bl2, DatumShiftGrid<?, ?> datumShiftGrid) {
        this.context = new ContextualParameters(parameterDescriptorGroup, bl ? 4 : 3, bl2 ? 4 : 3);
        this.grid = datumShiftGrid;
    }

    static void ensureGeocentricTranslation(DatumShiftGrid<?, ?> datumShiftGrid, Unit<Length> unit) throws IllegalArgumentException {
        int n = datumShiftGrid.getTranslationDimensions();
        if (n != 3) {
            throw new MismatchedDimensionException(Errors.format((short)81, (Object)"grid", (Object)3, (Object)n));
        }
        Unit<?> unit2 = "ratio";
        if (datumShiftGrid.isCellValueRatio() || (unit2 = datumShiftGrid.getTranslationUnit()) != unit) {
            throw new IllegalArgumentException(Resources.format((short)26, "translation", unit2));
        }
    }

    final void setContextParameters(double d, double d2, Unit<Length> unit, Ellipsoid ellipsoid) {
        UnitConverter unitConverter = ellipsoid.getAxisUnit().getConverterTo(unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(d, unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(d2, unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MAJOR).setValue(unitConverter.convert(ellipsoid.getSemiMajorAxis()), unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MINOR).setValue(unitConverter.convert(ellipsoid.getSemiMinorAxis()), unit);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return super.equals(object, comparisonMode) && Objects.equals(this.grid, ((DatumShiftTransform)object).grid);
    }
}

