/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class EllipsoidToCentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static ParameterDescriptorGroup DESCRIPTOR;
    private static final double ECCENTRICITY_THRESHOLD = 0.16;
    protected final double eccentricitySquared;
    private transient double axisRatio;
    private transient boolean useIterations;
    final boolean withHeight;
    final ContextualParameters context;
    private final AbstractMathTransform inverse;

    protected EllipsoidToCentricTransform(double d, double d2, Unit<Length> unit, boolean bl, TargetType targetType) {
        ArgumentChecks.ensureStrictlyPositive((String)"semiMajor", (double)d);
        ArgumentChecks.ensureStrictlyPositive((String)"semiMinor", (double)d2);
        ArgumentChecks.ensureNonNull((String)"target", (Object)((Object)targetType));
        this.axisRatio = d2 / d;
        this.eccentricitySquared = 1.0 - this.axisRatio * this.axisRatio;
        this.useIterations = this.eccentricitySquared >= 0.0256;
        this.withHeight = bl;
        this.context = new ContextualParameters(GeographicToGeocentric.PARAMETERS, bl ? 4 : 3, 4);
        this.context.getOrCreate(MapProjection.SEMI_MAJOR).setValue(d, unit);
        this.context.getOrCreate(MapProjection.SEMI_MINOR).setValue(d2, unit);
        this.context.normalizeGeographicInputs(0.0);
        DoubleDouble doubleDouble = new DoubleDouble(d);
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        for (int i = 0; i < 3; ++i) {
            matrixSIS.convertAfter(i, (Number)doubleDouble, null);
        }
        if (bl) {
            doubleDouble.inverseDivide(1.0, 0.0);
            MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            matrixSIS2.convertBefore(2, (Number)doubleDouble, null);
        }
        this.inverse = new Inverse();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.useIterations = this.eccentricitySquared >= 0.0256;
        this.axisRatio = Math.sqrt(1.0 - this.eccentricitySquared);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory mathTransformFactory, double d, double d2, Unit<Length> unit, boolean bl, TargetType targetType) throws FactoryException {
        if (Math.abs(d - d2) <= d * 1.5696105811844188E-9) {
            MatrixSIS matrixSIS = Matrices.createDiagonal(4, bl ? 4 : 3);
            matrixSIS.setElement(2, bl ? 3 : 2, d);
            if (!bl) {
                matrixSIS.setElement(3, 2, 1.0);
            }
            MathTransform mathTransform = SphericalToCartesian.INSTANCE.completeTransform(mathTransformFactory);
            return mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createAffineTransform((Matrix)matrixSIS), mathTransform);
        }
        EllipsoidToCentricTransform ellipsoidToCentricTransform = new EllipsoidToCentricTransform(d, d2, unit, bl, targetType);
        return ellipsoidToCentricTransform.context.completeTransform(mathTransformFactory, ellipsoidToCentricTransform);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory mathTransformFactory, Ellipsoid ellipsoid, boolean bl) throws FactoryException {
        return EllipsoidToCentricTransform.createGeodeticConversion(mathTransformFactory, ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), (Unit<Length>)ellipsoid.getAxisUnit(), bl, TargetType.CARTESIAN);
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters parameters = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        parameters.getOrCreate(MapProjection.ECCENTRICITY).setValue(Math.sqrt(this.eccentricitySquared));
        parameters.parameter("target").setValue((Object)this.getTargetType());
        parameters.getOrCreate(GeocentricAffineBetweenGeographic.DIMENSION).setValue(this.getSourceDimensions());
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<EllipsoidToCentricTransform> clazz = EllipsoidToCentricTransform.class;
        synchronized (EllipsoidToCentricTransform.class) {
            if (DESCRIPTOR == null) {
                ParameterBuilder parameterBuilder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
                ParameterDescriptor<TargetType> parameterDescriptor = ((ParameterBuilder)parameterBuilder.setRequired(true).addName("target")).create(TargetType.class, TargetType.CARTESIAN);
                DESCRIPTOR = ((ParameterBuilder)parameterBuilder.addName("Ellipsoid (radians domain) to centric")).createGroup(1, 1, new GeneralParameterDescriptor[]{MapProjection.ECCENTRICITY, parameterDescriptor, GeocentricAffineBetweenGeographic.DIMENSION});
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return this.withHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    public final TargetType getTargetType() {
        return TargetType.CARTESIAN;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        double d;
        boolean bl;
        int n = directPosition.getDimension();
        switch (n) {
            default: {
                throw EllipsoidToCentricTransform.mismatchedDimension("point", this.getSourceDimensions(), n);
            }
            case 3: {
                bl = true;
                d = directPosition.getOrdinate(2);
                break;
            }
            case 2: {
                bl = false;
                d = 0.0;
            }
        }
        return this.transform(directPosition.getOrdinate(0), directPosition.getOrdinate(1), d, null, 0, true, bl);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        return this.transform(dArray[n], dArray[n + 1], this.withHeight ? dArray[n + 2] : 0.0, dArray2, n2, bl, this.withHeight);
    }

    private Matrix transform(double d, double d2, double d3, double[] dArray, int n, boolean bl, boolean bl2) {
        double d4;
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        double d9 = 1.0 / (1.0 - this.eccentricitySquared * (d8 * d8));
        double d10 = Math.sqrt(d9);
        double d11 = d10 + d3;
        double d12 = d10 * (1.0 - this.eccentricitySquared);
        if (dArray != null) {
            d4 = d11 * d7;
            dArray[n] = d4 * d5;
            dArray[n + 1] = d4 * d6;
            dArray[n + 2] = (d12 + d3) * d8;
        }
        if (!bl) {
            return null;
        }
        d4 = d12 * d9 + d3;
        double d13 = d7 * d5;
        double d14 = d7 * d6;
        double d15 = -d11 * d14;
        double d16 = d11 * d13;
        double d17 = -d4 * (d8 * d5);
        double d18 = -d4 * (d8 * d6);
        double d19 = d4 * d7;
        if (bl2) {
            return new Matrix3(d15, d17, d13, d16, d18, d14, 0.0, d19, d8);
        }
        return Matrices.create(3, 2, new double[]{d15, d17, d16, d18, 0.0, d19});
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = 0;
        int n5 = 0;
        if (dArray == dArray2) {
            int n6 = this.getSourceDimensions();
            switch (IterationStrategy.suggest(n, n6, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n6;
                    n2 += (n3 - 1) * 3;
                    n4 = -2 * n6;
                    n5 = -6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n6);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = this.withHeight ? dArray[n++] : 0.0;
            double d4 = Math.sin(d2);
            double d5 = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (d4 * d4));
            double d6 = (d5 + d3) * Math.cos(d2);
            dArray2[n2++] = d6 * Math.cos(d);
            dArray2[n2++] = d6 * Math.sin(d);
            dArray2[n2++] = (d5 * (1.0 - this.eccentricitySquared) + d3) * d4;
            n += n4;
            n2 += n5;
        }
    }

    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = 0;
        int n5 = 0;
        if (dArray == dArray2) {
            int n6 = this.getSourceDimensions();
            switch (IterationStrategy.suggest(n, 3, n2, n6, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * 3;
                    n2 += (n3 - 1) * n6;
                    n4 = -6;
                    n5 = -2 * n6;
                    break;
                }
                default: {
                    dArray2 = Arrays.copyOfRange(dArray2, n2, n2 + n3 * n6);
                    n2 = 0;
                }
            }
        }
        block4: while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = Math.hypot(d, d2);
            double d5 = d3 / (d4 * this.axisRatio);
            double d6 = 1.0 / (1.0 + d5 * d5);
            double d7 = 1.0 - d6;
            double d8 = Math.atan((d3 + Math.copySign(this.eccentricitySquared * d7 * Math.sqrt(d7), d5) / this.axisRatio) / (d4 - this.eccentricitySquared * d6 * Math.sqrt(d6)));
            if (!this.useIterations) {
                dArray2[n2++] = Math.atan2(d2, d);
                dArray2[n2++] = d8;
                if (this.withHeight) {
                    double d9 = Math.sin(d8);
                    double d10 = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (d9 * d9));
                    dArray2[n2++] = d4 / Math.cos(d8) - d10;
                }
                n += n4;
                n2 += n5;
                continue;
            }
            for (int i = 0; i < 15; ++i) {
                double d11 = Math.sin(d8);
                double d12 = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (d11 * d11));
                double d13 = d8 - (d8 = Math.atan((d3 + this.eccentricitySquared * d12 * d11) / d4));
                if (Math.abs(d13) >= 3.926676682852614E-10) continue;
                dArray2[n2++] = Math.atan2(d2, d);
                dArray2[n2++] = d8;
                if (this.withHeight) {
                    dArray2[n2++] = d4 / Math.cos(d8) - d12;
                }
                n += n4;
                n2 += n5;
                continue block4;
            }
            throw new TransformException(Resources.format((short)46));
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        int n = super.computeHashCode() + Numerics.hashCode((long)Double.doubleToLongBits(this.axisRatio));
        if (this.withHeight) {
            n += 37;
        }
        return n;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            EllipsoidToCentricTransform ellipsoidToCentricTransform = (EllipsoidToCentricTransform)object;
            return this.withHeight == ellipsoidToCentricTransform.withHeight && Numerics.equals((double)this.axisRatio, (double)ellipsoidToCentricTransform.axisRatio);
        }
        return false;
    }

    @Override
    final int beforeFormat(List<Object> list, int n, boolean bl) {
        n = super.beforeFormat(list, n, bl);
        if (!this.withHeight) {
            list.add(n++, new Geographic3Dto2D.WKT(true));
        }
        return n;
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        Matrix matrix;
        if (bl && this.withHeight && mathTransform instanceof LinearTransform && mathTransform.getSourceDimensions() == 2 && (matrix = ((LinearTransform)mathTransform).getMatrix()).getElement(2, 0) == 0.0 && matrix.getElement(2, 1) == 0.0 && matrix.getElement(2, 2) == 0.0) {
            matrix = MatrixSIS.castOrCopy(matrix).removeRows(2, 3);
            EllipsoidToCentricTransform ellipsoidToCentricTransform = this.create2D();
            if (mathTransformFactory != null) {
                return mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createAffineTransform(matrix), (MathTransform)ellipsoidToCentricTransform);
            }
            return ConcatenatedTransform.create(MathTransforms.linear(matrix), ellipsoidToCentricTransform, mathTransformFactory);
        }
        return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
    }

    final EllipsoidToCentricTransform create2D() {
        ParameterValue<Double> parameterValue = this.context.getOrCreate(MapProjection.SEMI_MAJOR);
        Unit unit = parameterValue.getUnit().asType(Length.class);
        return new EllipsoidToCentricTransform(parameterValue.doubleValue(), this.context.getOrCreate(MapProjection.SEMI_MINOR).doubleValue(unit), (Unit<Length>)unit, false, this.getTargetType());
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6942084702259211803L;

        Inverse() {
        }

        @Override
        protected ContextualParameters getContextualParameters() {
            return EllipsoidToCentricTransform.this.context.inverse(GeocentricToGeographic.PARAMETERS);
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
            parameterValueGroup.values().addAll(EllipsoidToCentricTransform.this.getParameterValues().values());
            return parameterValueGroup;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return new DefaultParameterDescriptorGroup(Collections.singletonMap("name", new ImmutableIdentifier(Citations.SIS, "SIS", "Centric to ellipsoid (radians domain)")), EllipsoidToCentricTransform.this.getParameterDescriptors());
        }

        @Override
        public Matrix derivative(DirectPosition directPosition) throws TransformException {
            ArgumentChecks.ensureNonNull((String)"point", (Object)directPosition);
            double[] dArray = directPosition.getCoordinate();
            ArgumentChecks.ensureDimensionMatches((String)"point", (int)3, (double[])dArray);
            return this.transform(dArray, 0, dArray, 0, true);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            int n3;
            double[] dArray3;
            if (bl && (dArray2 == null || !EllipsoidToCentricTransform.this.withHeight)) {
                dArray3 = new double[3];
                n3 = 0;
            } else {
                dArray3 = dArray2;
                n3 = n2;
            }
            EllipsoidToCentricTransform.this.inverseTransform(dArray, n, dArray3, n3, 1);
            if (!bl) {
                return null;
            }
            if (dArray2 != dArray3 && dArray2 != null) {
                dArray2[n2] = dArray3[0];
                dArray2[n2 + 1] = dArray3[1];
            }
            Matrix matrix = EllipsoidToCentricTransform.this.derivative(new DirectPositionView(dArray3, n3, 3));
            matrix = Matrices.inverse(matrix);
            if (!EllipsoidToCentricTransform.this.withHeight) {
                matrix = MatrixSIS.castOrCopy(matrix).removeRows(2, 3);
            }
            return matrix;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            EllipsoidToCentricTransform.this.inverseTransform(dArray, n, dArray2, n2, n3);
        }

        @Override
        protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
            Matrix matrix;
            if (!bl && EllipsoidToCentricTransform.this.withHeight && mathTransform instanceof LinearTransform && mathTransform.getTargetDimensions() == 2 && (matrix = ((LinearTransform)mathTransform).getMatrix()).getElement(0, 2) == 0.0 && matrix.getElement(1, 2) == 0.0 && matrix.getElement(2, 2) == 0.0) {
                matrix = MatrixSIS.castOrCopy(matrix).removeColumns(2, 3);
                MathTransform mathTransform2 = EllipsoidToCentricTransform.this.create2D().inverse();
                if (mathTransformFactory != null) {
                    return mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransformFactory.createAffineTransform(matrix));
                }
                return ConcatenatedTransform.create(mathTransform2, MathTransforms.linear(matrix), mathTransformFactory);
            }
            return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
        }

        @Override
        final int beforeFormat(List<Object> list, int n, boolean bl) {
            n = super.beforeFormat(list, n, bl);
            if (!EllipsoidToCentricTransform.this.withHeight) {
                list.add(++n, new Geographic3Dto2D.WKT(false));
            }
            return n;
        }
    }

    public static enum TargetType {
        CARTESIAN;

    }
}

