/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Interpolation1D;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LinearInterpolator1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = -5025693608589996896L;
    private final double[] values;
    private final double slope;
    private final MathTransform1D inverse;

    private LinearInterpolator1D(double[] dArray, double d) {
        this.values = dArray;
        this.slope = d;
        double d2 = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (d2 <= (d2 = dArray[i])) continue;
            this.inverse = null;
            return;
        }
        this.inverse = new Inverse();
    }

    private static MathTransform1D create(double[] dArray) {
        boolean bl;
        double d;
        int n = dArray.length - 1;
        double d2 = dArray[0];
        double d3 = (dArray[n] - d2) / (double)n;
        double d4 = Math.abs(d3);
        int n2 = 0;
        do {
            if (++n2 < n) continue;
            return LinearTransform1D.create(d3, d2);
        } while (Numerics.epsilonEqual((double)(d = dArray[n2]), (double)(d2 + d3 * (double)n2), (double)(Math.max(Math.abs(d), d4) * 1.0E-13)));
        boolean bl2 = bl = d3 < 0.0;
        if (bl) {
            d3 = -d3;
            for (n2 = 0; n2 <= n; ++n2) {
                dArray[n2] = -dArray[n2];
            }
        }
        AbstractMathTransform abstractMathTransform = new LinearInterpolator1D(dArray, d3);
        if (bl) {
            abstractMathTransform = new ConcatenatedTransformDirect1D((MathTransform1D)abstractMathTransform, LinearTransform1D.NEGATE);
        }
        return abstractMathTransform;
    }

    static MathTransform1D create(double[] dArray, double[] dArray2) {
        int n;
        if (dArray == null) {
            if (dArray2 == null) {
                return IdentityTransform1D.INSTANCE;
            }
            n = dArray2.length;
        } else {
            n = dArray.length;
            if (dArray2 != null && dArray2.length != n) {
                throw new IllegalArgumentException(Errors.format((short)77));
            }
        }
        switch (n) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, (Object)(dArray != null ? "preimage" : "values")));
            }
            case 1: {
                return LinearTransform1D.constant(dArray != null ? dArray[0] : Double.NaN, dArray2 != null ? dArray2[0] : Double.NaN);
            }
        }
        MathTransform1D mathTransform1D = null;
        if (dArray2 != null) {
            mathTransform1D = LinearInterpolator1D.create((double[])dArray2.clone());
        }
        if (dArray != null) {
            MathTransform1D mathTransform1D2 = mathTransform1D;
            try {
                mathTransform1D = LinearInterpolator1D.create((double[])dArray.clone()).inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(Resources.format((short)55, "preimage"), noninvertibleTransformException);
            }
            if (mathTransform1D2 != null) {
                mathTransform1D = MathTransforms.concatenate(mathTransform1D, mathTransform1D2);
            }
        }
        return mathTransform1D;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Interpolation1D.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        parameterValueGroup.parameter("values").setValue((Object)this.values);
        return parameterValueGroup;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == (double)i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d;
        double d2;
        double d3 = dArray[n];
        if (d3 >= 0.0) {
            int n3 = (int)d3;
            int n4 = this.values.length - 1;
            if (n3 < n4) {
                d2 = this.values[n3] * (1.0 - (d3 -= (double)n3)) + this.values[n3 + 1] * d3;
                d = this.values[n3 + 1] - this.values[n3];
            } else {
                d2 = (d3 - (double)n4) * this.slope + this.values[n4];
                d = this.slope;
            }
        } else {
            d2 = d3 * this.slope + this.values[0];
            d = this.slope;
        }
        if (dArray2 != null) {
            dArray2[n2] = d2;
        }
        return bl ? new Matrix1(d) : null;
    }

    @Override
    public double transform(double d) {
        if (d >= 0.0) {
            int n = (int)d;
            int n2 = this.values.length - 1;
            if (n < n2) {
                return this.values[n] * (1.0 - (d -= (double)n)) + this.values[n + 1] * d;
            }
            return (d - (double)n2) * this.slope + this.values[n2];
        }
        return d * this.slope + this.values[0];
    }

    @Override
    public double derivative(double d) {
        int n;
        if (d >= 0.0 && (n = (int)d) < this.values.length - 1) {
            return this.values[n + 1] - this.values[n];
        }
        return this.slope;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            return Arrays.equals(this.values, ((LinearInterpolator1D)object).values);
        }
        return false;
    }

    private final class Inverse
    extends AbstractMathTransform1D.Inverse
    implements MathTransform1D {
        private static final long serialVersionUID = 3179638888992528901L;

        Inverse() {
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d;
            double d2;
            double d3 = dArray[n];
            double[] dArray3 = LinearInterpolator1D.this.values;
            int n3 = Arrays.binarySearch(dArray3, d3);
            if (n3 >= 0) {
                d2 = n3;
                d = n3 >= 1 && n3 < dArray3.length ? dArray3[n3] - dArray3[n3 - 1] : LinearInterpolator1D.this.slope;
            } else if ((n3 ^= 0xFFFFFFFF) >= 1) {
                if (n3 < dArray3.length) {
                    double d4 = dArray3[n3 - 1];
                    d = dArray3[n3] - d4;
                    d2 = (d3 - d4) / d + (double)(n3 - 1);
                } else {
                    int n4 = dArray3.length - 1;
                    d = LinearInterpolator1D.this.slope;
                    d2 = (d3 - dArray3[n4]) / d + (double)n4;
                }
            } else {
                d = LinearInterpolator1D.this.slope;
                d2 = (d3 - dArray3[0]) / d;
            }
            if (dArray2 != null) {
                dArray2[n2] = d2;
            }
            return bl ? new Matrix1(1.0 / d) : null;
        }

        public double transform(double d) {
            double[] dArray = LinearInterpolator1D.this.values;
            int n = Arrays.binarySearch(dArray, d);
            if (n >= 0) {
                return n;
            }
            if ((n ^= 0xFFFFFFFF) >= 1) {
                if (n < dArray.length) {
                    double d2 = dArray[n - 1];
                    return (d - d2) / (dArray[n] - d2) + (double)(n - 1);
                }
                int n2 = dArray.length - 1;
                return (d - dArray[n2]) / LinearInterpolator1D.this.slope + (double)n2;
            }
            return (d - dArray[0]) / LinearInterpolator1D.this.slope;
        }

        public double derivative(double d) {
            double[] dArray = LinearInterpolator1D.this.values;
            int n = Arrays.binarySearch(dArray, d);
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            }
            double d2 = n >= 1 && n < dArray.length ? dArray[n] - dArray[n - 1] : LinearInterpolator1D.this.slope;
            return 1.0 / d2;
        }
    }
}

