/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;

public class HTTPBindingMessageReferenceExtensionsImpl
extends BaseComponentExtensionContext
implements HTTPBindingMessageReferenceExtensions {
    public HTTPBindingMessageReferenceExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("http content encoding"), this.getProperty("http headers")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("http content encoding".equals(propertyName)) {
            return this.newExtensionProperty("http content encoding", this.getHttpContentEncoding());
        }
        if ("http headers".equals(propertyName)) {
            return this.newExtensionProperty("http headers", this.getHttpHeaders());
        }
        return null;
    }

    public String getHttpContentEncoding() {
        StringAttr contentEncoding = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING);
        return contentEncoding != null ? contentEncoding.getString() : null;
    }

    public HTTPHeader[] getHttpHeaders() {
        ExtensionElement[] extEls = ((WSDLElement)((Object)this.getParent())).getExtensionElementsOfType(HTTPConstants.Q_ELEM_HTTP_HEADER);
        int len = extEls.length;
        HTTPHeader[] httpHeaders = new HTTPHeader[len];
        System.arraycopy(extEls, 0, httpHeaders, 0, len);
        return httpHeaders;
    }
}

