/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.FullConditionalExpression;
import com.strobel.expressions.FullConditionalExpressionWithType;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;

public class ConditionalExpression
extends Expression {
    private final Expression _test;
    private final Expression _ifTrue;

    ConditionalExpression(Expression test, Expression ifTrue) {
        this._test = test;
        this._ifTrue = ifTrue;
    }

    public final Expression getTest() {
        return this._test;
    }

    public final Expression getIfTrue() {
        return this._ifTrue;
    }

    public Expression getIfFalse() {
        return Expression.empty();
    }

    @Override
    public Type<?> getType() {
        return this._ifTrue.getType();
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Conditional;
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitConditional(this);
    }

    static ConditionalExpression make(Expression test, Expression ifTrue, Expression ifFalse, Type type) {
        if (!TypeUtils.areEquivalent(ifTrue.getType(), (Type)type) || !TypeUtils.areEquivalent(ifFalse.getType(), (Type)type)) {
            return new FullConditionalExpressionWithType(test, ifTrue, ifFalse, type);
        }
        if (ifFalse instanceof DefaultValueExpression && ifFalse.getType() == PrimitiveTypes.Void) {
            return new ConditionalExpression(test, ifTrue);
        }
        return new FullConditionalExpression(test, ifTrue, ifFalse);
    }

    public ConditionalExpression update(Expression test, Expression ifTrue, Expression ifFalse) {
        if (test == this.getTest() && ifTrue == this.getIfTrue() && ifFalse == this.getIfFalse()) {
            return this;
        }
        return Expression.condition(test, ifTrue, ifFalse, this.getType());
    }
}

