/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc;

import java.util.Collections;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.classgen.asm.WriterControllerFactory;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesWriterControllerFactoryImpl;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.StaticTypesTransformation;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.StaticCompilationVisitor;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.TypeCheckerPluginFactory;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class StaticCompileTransformation
extends StaticTypesTransformation {
    private final StaticTypesWriterControllerFactoryImpl factory = new StaticTypesWriterControllerFactoryImpl();

    public void visit(ASTNode[] nodes, SourceUnit source) {
        StaticCompilationTransformer transformer = new StaticCompilationTransformer(source);
        AnnotatedNode node = (AnnotatedNode)nodes[1];
        StaticTypeCheckingVisitor visitor = null;
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            visitor = this.newVisitor(source, classNode, null);
            classNode.putNodeMetaData(WriterControllerFactory.class, this.factory);
            node.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, !visitor.isSkipMode(node));
            visitor.visitClass(classNode);
        } else if (node instanceof MethodNode) {
            MethodNode methodNode;
            ClassNode declaringClass = (methodNode = (MethodNode)node).getDeclaringClass();
            visitor = this.newVisitor(source, declaringClass, null);
            methodNode.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, !visitor.isSkipMode(node));
            if (declaringClass.getNodeMetaData(WriterControllerFactory.class) == null) {
                declaringClass.putNodeMetaData(WriterControllerFactory.class, this.factory);
            }
            visitor.setMethodsToBeVisited(Collections.singleton(methodNode));
            visitor.visitMethod(methodNode);
        } else {
            source.addError(new SyntaxException("[Static type checking] - Unimplemented node type", node.getLineNumber(), node.getColumnNumber()));
        }
        if (visitor != null) {
            visitor.performSecondPass();
        }
        if (node instanceof ClassNode) {
            transformer.visitClass((ClassNode)node);
        } else if (node instanceof MethodNode) {
            transformer.visitMethod((MethodNode)node);
        }
    }

    protected StaticTypeCheckingVisitor newVisitor(SourceUnit unit, ClassNode node, TypeCheckerPluginFactory pluginFactory) {
        return new StaticCompilationVisitor(unit, node, pluginFactory);
    }
}

