/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsert;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsertSingleTable;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleBatched;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleNonBatched;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleSelfExecuting;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorStandard;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.sql.model.EntityMutationOperationGroup;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;

public class StandardMutationExecutorService
implements MutationExecutorService {
    private final int globalBatchSize;

    public StandardMutationExecutorService(Map<String, Object> configurationValues) {
        this(ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationValues, 1));
    }

    public StandardMutationExecutorService(int globalBatchSize) {
        this.globalBatchSize = globalBatchSize;
    }

    @Override
    public MutationExecutor createExecutor(BatchKeyAccess batchKeySupplier, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        Integer sessionBatchSize = session.getJdbcCoordinator().getJdbcSessionOwner().getJdbcBatchSize();
        int batchSizeToUse = sessionBatchSize == null ? this.globalBatchSize : sessionBatchSize;
        int numberOfOperations = operationGroup.getNumberOfOperations();
        MutationType mutationType = operationGroup.getMutationType();
        EntityMutationOperationGroup entityMutationOperationGroup = operationGroup.asEntityMutationOperationGroup();
        if (mutationType == MutationType.INSERT && entityMutationOperationGroup != null && entityMutationOperationGroup.getMutationTarget().getIdentityInsertDelegate() != null) {
            if (numberOfOperations > 1) {
                return new MutationExecutorPostInsert(entityMutationOperationGroup, session);
            }
            return new MutationExecutorPostInsertSingleTable(entityMutationOperationGroup, session);
        }
        if (numberOfOperations == 1) {
            MutationOperation singleOperation = operationGroup.getSingleOperation();
            if (singleOperation instanceof SelfExecutingUpdateOperation) {
                return new MutationExecutorSingleSelfExecuting((SelfExecutingUpdateOperation)singleOperation, session);
            }
            PreparableMutationOperation jdbcOperation = (PreparableMutationOperation)singleOperation;
            BatchKey batchKey = batchKeySupplier.getBatchKey();
            if (jdbcOperation.canBeBatched(batchKey, batchSizeToUse)) {
                return new MutationExecutorSingleBatched(jdbcOperation, batchKey, batchSizeToUse, session);
            }
            return new MutationExecutorSingleNonBatched(jdbcOperation, session);
        }
        return new MutationExecutorStandard(operationGroup, batchKeySupplier, batchSizeToUse, session);
    }
}

