/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class CollectionTableGroup
extends StandardTableGroup
implements PluralTableGroup {
    private TableGroup indexTableGroup;
    private TableGroup elementTableGroup;

    public CollectionTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, PluralAttributeMapping tableGroupProducer, boolean fetched, String sourceAlias, TableReference primaryTableReference, boolean realTableGroup, SqlAliasBase sqlAliasBase, Predicate<String> tableReferenceJoinNameChecker, BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, fetched, sourceAlias, primaryTableReference, realTableGroup, sqlAliasBase, tableReferenceJoinNameChecker, tableReferenceJoinCreator, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getModelPart() {
        return (PluralAttributeMapping)super.getModelPart();
    }

    @Override
    public TableGroup getElementTableGroup() {
        return this.elementTableGroup;
    }

    @Override
    public TableGroup getIndexTableGroup() {
        return this.indexTableGroup;
    }

    public void registerIndexTableGroup(TableGroupJoin indexTableGroupJoin) {
        assert (this.indexTableGroup == null);
        this.indexTableGroup = indexTableGroupJoin.getJoinedGroup();
        this.addNestedTableGroupJoin(indexTableGroupJoin);
    }

    public void registerElementTableGroup(TableGroupJoin elementTableGroupJoin) {
        assert (this.elementTableGroup == null);
        this.elementTableGroup = elementTableGroupJoin.getJoinedGroup();
        this.addNestedTableGroupJoin(elementTableGroupJoin);
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference indexTableReference;
        TableReference tableReference = super.getTableReference(navigablePath, tableExpression, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        if (this.indexTableGroup != null && (navigablePath == null || this.indexTableGroup.getNavigablePath().isParent(navigablePath)) && (indexTableReference = this.indexTableGroup.getTableReference(navigablePath, tableExpression, resolve)) != null) {
            return indexTableReference;
        }
        if (this.elementTableGroup != null && (navigablePath == null || this.elementTableGroup.getNavigablePath().isParent(navigablePath))) {
            TableReference elementTableReference = this.elementTableGroup.getTableReference(navigablePath, tableExpression, resolve);
            return elementTableReference;
        }
        return null;
    }
}

