/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private static final int CHUNK_LEN = 1;
    private static final int CHUNK_DATA = 2;
    private static final int CHUNK_CRLF = 3;
    private static final int CHUNK_INVALID = Integer.MAX_VALUE;
    private static final int BUFFER_SIZE = 2048;
    private final DataInputStream in;
    private int state;
    private int chunkSize;
    private int pos;
    private boolean eof = false;
    private boolean closed = false;

    public ChunkedInputStream(DataInputStream in) {
        this.in = in;
        this.pos = 0;
        this.state = 1;
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((b = this.in.read()) != -1) {
            ++this.pos;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((bytesRead = this.in.read(b, off, Math.min(len, this.chunkSize - this.pos))) != -1) {
            this.pos += bytesRead;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
            return bytesRead;
        }
        this.eof = true;
        throw new RuntimeException("Truncated chunk ( expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextChunk() throws IOException {
        if (this.state == Integer.MAX_VALUE) {
            throw new RuntimeException("Corrupt data stream");
        }
        try {
            this.chunkSize = this.getChunkSize();
            if (this.chunkSize < 0) {
                throw new RuntimeException("Negative chunk size");
            }
            this.state = 2;
            this.pos = 0;
            if (this.chunkSize == 0) {
                this.eof = true;
            }
        }
        catch (RuntimeException ex) {
            this.state = Integer.MAX_VALUE;
            throw ex;
        }
    }

    private int getChunkSize() throws IOException {
        int st = this.state;
        switch (st) {
            case 3: {
                String line = this.in.readLine();
                int bytesRead1 = line.length();
                if (bytesRead1 == -1) {
                    throw new RuntimeException("CRLF expected at end of chunk");
                }
                if (!line.isEmpty()) {
                    throw new RuntimeException("Unexpected content at the end of chunk");
                }
                this.state = 1;
            }
            case 1: {
                int bytesRead2;
                String line = this.in.readLine();
                int n = bytesRead2 = line != null ? line.length() : -1;
                if (bytesRead2 == -1) {
                    throw new RuntimeException("Premature end of chunk coded message body: closing chunk expected");
                }
                int separator = line.indexOf(59);
                if (separator < 0) {
                    separator = line.length();
                }
                try {
                    return Integer.parseInt(line.substring(0, separator).trim(), 16);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Bad chunk header");
                }
            }
        }
        throw new IllegalStateException("Inconsistent codec state");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof && this.state != Integer.MAX_VALUE) {
                    byte[] buff = new byte[2048];
                    while (this.read(buff) >= 0) {
                    }
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }
}

