/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.javaweb.core.net.HttpResponse;

public abstract class HttpRequest {
    protected String method = "GET";
    protected URL url;
    protected int timeout = 15000;
    protected String charset = "UTF-8";
    protected String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36";
    protected String referer;
    protected boolean followRedirects = true;
    protected Map<String, String> requestHeader = new LinkedHashMap<String, String>();
    protected Map<String, String> requestDataMap = new LinkedHashMap<String, String>();
    protected String requestBae64InputStream;
    protected String contentType;
    protected String cookie;

    public HttpRequest method(Method method) {
        this.method = method.name();
        return this;
    }

    public HttpRequest url(URL url) {
        this.url = url;
        return this;
    }

    public HttpRequest url(String url) throws MalformedURLException {
        this.url = new URL(url);
        return this;
    }

    public HttpRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpRequest charset(String charset) {
        this.charset = charset;
        return this;
    }

    public HttpRequest userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpRequest referer(String referer) {
        this.referer = referer;
        return this;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest header(Map<String, String> requestHeader) {
        this.requestHeader.putAll(requestHeader);
        return this;
    }

    public HttpRequest header(String key, String value) {
        this.requestHeader.put(key, value);
        return this;
    }

    public HttpRequest data(InputStream in) {
        try {
            this.data(IOUtils.toByteArray((InputStream)in));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public HttpRequest data(Map<String, String> requestDataMap) {
        if (requestDataMap != null) {
            this.requestDataMap.putAll(requestDataMap);
        }
        return this;
    }

    public HttpRequest data(byte[] bytes) {
        this.requestBae64InputStream = Base64.encodeBase64String((byte[])bytes);
        return this;
    }

    public HttpRequest contentType(String contentType) {
        this.requestHeader.put("Content-Type", contentType);
        this.contentType = contentType;
        return this;
    }

    public HttpRequest cookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getReferer() {
        return this.referer;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Map<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public Map<String, String> getRequestDataMap() {
        return this.requestDataMap;
    }

    public String getRequestBae64InputStream() {
        return this.requestBae64InputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCookie() {
        return this.cookie;
    }

    public abstract HttpResponse request();

    public static enum Method {
        GET,
        POST,
        HEAD,
        TRACE,
        PUT,
        DELETE,
        OPTIONS,
        CONNECT;

    }
}

