/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.javaweb.core.net.HttpRequest;
import org.javaweb.core.utils.HttpRequestUtils;
import org.javaweb.core.utils.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HttpResponse {
    protected transient String data;
    private URL url;
    private int statusCode;
    private String statusMessage;
    private String contentType;
    private String base64Data;
    private String charset;
    private String exceptionName;
    private long requestTime;
    private long responseTime;
    private long lastModified;
    private String ip;
    private String hostName;
    private String canonicalHostName;
    private String domain;
    private Map<String, String> cookies = new LinkedHashMap<String, String>();
    private HttpRequest request;
    private Map<String, List<String>> header;

    public HttpResponse(String url) throws MalformedURLException {
        this.url = new URL(url);
        this.domain = this.url.getHost();
    }

    public HttpResponse(URL url) {
        this.url = url;
        this.domain = url.getHost();
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBase64Data() {
        return this.base64Data;
    }

    public void setBase64Data(String base64Data) {
        this.base64Data = base64Data;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    public void setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Map<String, List<String>> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, List<String>> header) {
        this.header = header;
    }

    public void dnsParse() throws UnknownHostException {
        InetAddress ia = InetAddress.getByName(this.domain);
        this.setIp(ia.getHostAddress());
        this.setHostName(ia.getHostAddress());
        this.setCanonicalHostName(ia.getCanonicalHostName());
    }

    public Document parse() {
        return Jsoup.parse((String)this.parseBody(), (String)this.getUrl().toString());
    }

    protected String parseBody() {
        return this.parseBody(null);
    }

    protected String parseBody(String charset) {
        if (this.data == null && StringUtils.isNotEmpty((String)this.getBase64Data())) {
            String htmlCharset = null;
            byte[] body = Base64.decodeBase64((String)this.getBase64Data());
            htmlCharset = charset != null && Charset.isSupported(charset) ? charset : HttpRequestUtils.parseHTMLCharset(body);
            if (Charset.isSupported(htmlCharset)) {
                this.setCharset("GB2312".equalsIgnoreCase(htmlCharset) ? "GBK" : htmlCharset);
            } else {
                this.setCharset("UTF-8");
            }
            try {
                this.data = new String(body, this.getCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.data;
    }

    public String body() {
        return this.parseBody();
    }

    public String body(String charset) {
        return this.parseBody(charset);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public void cookie(String cookieName, String cookieVal) {
        this.cookies.put(cookieName, cookieVal);
    }

    public void removeCookie(String key) {
        this.cookies.remove(key);
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }
}

