/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.javaweb.core.net.ChunkedInputStream;
import org.javaweb.core.utils.IOUtils;
import org.javaweb.core.utils.StringUtils;

public class HttpResponseParser {
    private static final int MAX_HEADER_LENGTH = 4096000;
    private String httpVersion;
    private int httpStatus = -1;
    private String httpStatusInfo;
    private Map<String, Object> headerMap = new CaseInsensitiveMap();
    private String header;
    private DataInputStream dis;
    private InputStream httpBodyInputStream;

    public HttpResponseParser(InputStream in) {
        this.dis = new DataInputStream(in);
        this.parse();
    }

    public static int getMaxHeaderLength() {
        return 4096000;
    }

    public static void main(String[] args) {
        String base64 = "SFRUUC8xLjEgMjAwIE9LDQpEYXRlOiBXZWQsIDA5IE5vdiAyMDE2IDE1OjAwOjAxIEdNVA0KVmFyeTogQWNjZXB0LUVuY29kaW5nDQpDb250ZW50LVR5cGU6IHRleHQvaHRtbA0KU2VydmVyOiBBcGFjaGUNCkNvbnRlbnQtRW5jb2Rpbmc6IGd6aXANClRyYW5zZmVyLUVuY29kaW5nOiBjaHVua2VkDQpDb25uZWN0aW9uOiBjbG9zZQ0KU2V0LUNvb2tpZTogVDEtSXBsV2ViLVN0YXRzYmJiYmJiYmJiYmJiYmJiYj1FRENMRE5MT0FDS0pNR0lDRVBNT0ZHTUVIQU9DTEZFSEhHREVFTlBJSENNUEJDQk1PT0xLSkhQTEZQRUtFT0tETkxMRElCRElHSkJISkJDRERNT0FQSE9HS0RMSERPSUZBRVBGQ09OSkJLSUNNSkhCTUZLRk5LQUNLRk5PREhIRzsgSHR0cE9ubHkNCg0KMjQNCh+LCAAAAAAAAAPzLy1R8E9TCE4tKstMTlVUBAAmA4HKEAAAAA0KMA0KDQo=";
        HttpResponseParser responseParser = new HttpResponseParser(new ByteArrayInputStream(Base64.decodeBase64((String)base64)));
        InputStream in = responseParser.getHttpBodyInputStream();
        try {
            String str = IOUtils.toString((InputStream)in, (String)"UTF-8");
            System.out.println(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getHttpStatusInfo() {
        return this.httpStatusInfo;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public String getHeader() {
        return this.header;
    }

    public InputStream getHttpBodyInputStream() {
        return this.httpBodyInputStream;
    }

    private void parse() {
        try {
            this.parseHttpResponseHeaderString();
            this.parseHttpResponseStatus();
            this.parseHttpResponseHeaderMap();
            this.parseHttpResponseBodyInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseHttpResponseHeaderString() {
        boolean loop = true;
        int a = 0;
        StringBuilder sb = new StringBuilder();
        try {
            String str = null;
            while (loop && (str = this.dis.readLine()) != null) {
                if ((a += str.length()) > 4096000) {
                    loop = false;
                    continue;
                }
                if (str.length() == 0) {
                    loop = false;
                    continue;
                }
                sb.append(str).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.header = sb.toString();
    }

    private void parseHttpResponseHeaderMap() throws IOException {
        if (StringUtils.isNotEmpty((String)this.header)) {
            BufferedReader br = null;
            try {
                String str = null;
                br = new BufferedReader(new StringReader(this.header));
                while ((str = br.readLine()) != null) {
                    String value;
                    int i = str.indexOf(":");
                    if (i == -1) continue;
                    String key = i > 0 ? str.substring(0, i) : "";
                    String string = value = str.length() - 1 > i ? str.substring(i + 1).trim() : "";
                    if (!this.headerMap.containsKey(key)) {
                        this.headerMap.put(key, value);
                        continue;
                    }
                    Object obj = this.headerMap.get(key);
                    if (obj instanceof String) {
                        this.headerMap.put(key, new String[]{(String)obj, value});
                        continue;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.addAll(Arrays.asList((String[])obj));
                    list.add(value);
                    this.headerMap.put(key, list.toArray(new String[list.size()]));
                }
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
        }
    }

    private void parseHttpResponseStatus() throws IOException {
        Matcher m;
        StringReader sr;
        String responseStatusLine;
        if (StringUtils.isNotEmpty((String)this.header) && StringUtils.isNotEmpty((String)(responseStatusLine = new BufferedReader(sr = new StringReader(this.header)).readLine())) && (m = Pattern.compile("^(HTTP/\\d\\.\\d) (\\d{3}) (.*)$").matcher(responseStatusLine)).find() && m.groupCount() == 3) {
            this.httpVersion = m.group(1);
            this.httpStatus = StringUtils.isNum(m.group(2)) ? Integer.parseInt(m.group(2)) : -1;
            this.httpStatusInfo = m.group(3);
        }
    }

    private void parseHttpResponseBodyInputStream() throws IOException {
        String transferEncoding;
        InputStream bodyInputStream = null;
        bodyInputStream = this.headerMap.containsKey("Transfer-Encoding") ? (StringUtils.isNotEmpty((String)(transferEncoding = (String)this.headerMap.get("Transfer-Encoding"))) && "chunked".equalsIgnoreCase(transferEncoding) ? new ChunkedInputStream(this.dis) : this.dis) : this.dis;
        if (this.headerMap.containsKey("Content-Encoding")) {
            String contentEncoding = (String)this.headerMap.get("Content-Encoding");
            FilterInputStream compressInputStream = null;
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                compressInputStream = new GZIPInputStream(bodyInputStream);
            } else if ("deflate".equalsIgnoreCase(contentEncoding)) {
                compressInputStream = new DeflaterInputStream(bodyInputStream);
            }
            if (compressInputStream != null) {
                bodyInputStream = compressInputStream;
            }
        }
        this.httpBodyInputStream = bodyInputStream;
    }
}

