/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.javaweb.core.net.HttpRequest;
import org.javaweb.core.net.HttpResponse;
import org.javaweb.core.utils.HttpRequestUtils;

public class HttpURLRequest
extends HttpRequest {
    private int maxBodySizeBytes = 0x500000;
    private String requestData;

    public HttpURLRequest() {
    }

    public HttpURLRequest(URL url) {
        this.url = url;
    }

    public HttpURLRequest(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public HttpURLRequest maxBodySizeBytes(int maxBodySizeBytes) {
        this.maxBodySizeBytes = maxBodySizeBytes;
        return this;
    }

    @Override
    public HttpURLRequest method(HttpRequest.Method method) {
        super.method(method);
        return this;
    }

    @Override
    public HttpURLRequest url(URL url) {
        super.url(url);
        return this;
    }

    @Override
    public HttpURLRequest url(String url) throws MalformedURLException {
        super.url(url);
        return this;
    }

    @Override
    public HttpURLRequest timeout(int timeout) {
        super.timeout(timeout);
        return this;
    }

    @Override
    public HttpURLRequest charset(String charset) {
        super.charset(charset);
        return this;
    }

    @Override
    public HttpURLRequest userAgent(String userAgent) {
        super.userAgent(userAgent);
        return this;
    }

    @Override
    public HttpURLRequest referer(String referer) {
        super.referer(referer);
        return this;
    }

    @Override
    public HttpURLRequest followRedirects(boolean followRedirects) {
        super.followRedirects(followRedirects);
        return this;
    }

    @Override
    public HttpURLRequest header(Map<String, String> requestHeader) {
        super.header(requestHeader);
        return this;
    }

    @Override
    public HttpURLRequest header(String key, String value) {
        super.header(key, value);
        return this;
    }

    public HttpURLRequest data(String requestData) {
        this.requestData = requestData;
        return this;
    }

    public HttpURLRequest data(String key, String value) {
        this.requestDataMap.put(key, value);
        return this;
    }

    @Override
    public HttpURLRequest data(InputStream in) {
        super.data(in);
        return this;
    }

    @Override
    public HttpURLRequest data(byte[] bytes) {
        super.data(bytes);
        return this;
    }

    @Override
    public HttpURLRequest contentType(String contentType) {
        super.contentType(contentType);
        return this;
    }

    @Override
    public HttpURLRequest cookie(String cookie) {
        super.cookie(cookie);
        return this;
    }

    public int getMaxBodySizeBytes() {
        return this.maxBodySizeBytes;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public HttpResponse get() {
        this.method(HttpRequest.Method.GET);
        return HttpRequestUtils.httpRequest(this);
    }

    public HttpResponse post() {
        this.method(HttpRequest.Method.POST);
        return HttpRequestUtils.httpRequest(this);
    }

    @Override
    public HttpResponse request() {
        return HttpRequestUtils.httpRequest(this);
    }
}

