/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.javaweb.core.net.HttpRequest;
import org.javaweb.core.net.HttpResponse;
import org.javaweb.core.net.MultipartFileField;
import org.javaweb.core.utils.HttpRequestUtils;
import org.javaweb.core.utils.IOUtils;
import org.javaweb.core.utils.SslUtils;
import org.javaweb.core.utils.StringUtils;

public class MultipartRequest
extends HttpRequest {
    private static final String LINE_FEED = "\r\n";
    private final String boundary;
    private Set<MultipartFileField> fileField = new LinkedHashSet<MultipartFileField>();

    public MultipartRequest(String requestURL) throws IOException {
        URL url;
        this.boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
        this.url = url = new URL(requestURL);
        String protocol = this.url.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new MalformedURLException("\u53ea\u652f\u6301 http & https \u8bf7\u6c42\u534f\u8bae.");
        }
        if ("https".equalsIgnoreCase(protocol)) {
            SslUtils.ignoreSsl();
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        try {
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("action", "queryDetail");
            data.put("wzlb", "DCFS");
            data.put("noticeId", "356-1 and 1<ascii(substr(user, 1, 1))");
            data.put("showwzlb", "");
            String url = "http://javaweb.org/1.php?XDEBUG_SESSION_START=11391";
            LinkedHashSet<MultipartFileField> fileFields = new LinkedHashSet<MultipartFileField>();
            MultipartFileField field1 = new MultipartFileField("1.html", new FileInputStream("/Users/yz/1.html"));
            MultipartFileField field2 = new MultipartFileField("file2", "2.txt", new FileInputStream("/Users/yz/2.txt"));
            fileFields.add(field1);
            fileFields.add(field2);
            HttpResponse response = ((MultipartRequest)new MultipartRequest(url).data(data)).files(fileFields).request();
            System.out.println(response.body());
            System.out.println(response.getExceptionName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MultipartRequest method(HttpRequest.Method method) {
        super.method(method);
        return this;
    }

    @Override
    public MultipartRequest url(URL url) {
        super.url(url);
        return this;
    }

    @Override
    public MultipartRequest url(String url) throws MalformedURLException {
        super.url(url);
        return this;
    }

    @Override
    public MultipartRequest timeout(int timeout) {
        super.timeout(timeout);
        return this;
    }

    @Override
    public MultipartRequest charset(String charset) {
        super.charset(charset);
        return this;
    }

    @Override
    public MultipartRequest userAgent(String userAgent) {
        super.userAgent(userAgent);
        return this;
    }

    @Override
    public MultipartRequest referer(String referer) {
        super.referer(referer);
        return this;
    }

    @Override
    public MultipartRequest followRedirects(boolean followRedirects) {
        super.followRedirects(followRedirects);
        return this;
    }

    @Override
    public MultipartRequest header(Map<String, String> requestHeader) {
        super.header(requestHeader);
        return this;
    }

    @Override
    public MultipartRequest header(String key, String value) {
        super.header(key, value);
        return this;
    }

    @Override
    public MultipartRequest data(InputStream in) {
        super.data(in);
        return this;
    }

    @Override
    public MultipartRequest contentType(String contentType) {
        super.contentType(contentType);
        return this;
    }

    @Override
    public MultipartRequest cookie(String cookie) {
        super.cookie(cookie);
        return this;
    }

    public MultipartRequest files(Set<MultipartFileField> fileField) {
        this.fileField.addAll(fileField);
        return this;
    }

    public MultipartRequest file(MultipartFileField fileField) {
        this.fileField.add(fileField);
        return this;
    }

    public MultipartRequest data(String key, String value) {
        this.fileField.add(new MultipartFileField(key, value));
        return this;
    }

    @Override
    public MultipartRequest data(Map<String, String> requestDataMap) {
        if (requestDataMap != null) {
            this.requestDataMap = requestDataMap;
            for (String key : requestDataMap.keySet()) {
                String value = requestDataMap.get(key);
                MultipartFileField field = new MultipartFileField(key, value);
                this.fileField.add(field);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setRequestFormData(OutputStream out) throws IOException {
        if (StringUtils.isNotEmpty(this.fileField)) {
            for (MultipartFileField field : this.fileField) {
                out.write(("--" + this.boundary + "\r\n").getBytes());
                if (field.getFileName() != null) {
                    if (field.getContentType() == null) {
                        field.setContentType(HttpURLConnection.guessContentTypeFromName(field.getFileName()));
                    }
                    out.write(("Content-Disposition: form-data; name=\"" + field.getFieldName() + "\"; filename=\"" + field.getFileName() + "\"" + "\r\n").getBytes(this.charset));
                    out.write(("Content-Type: " + field.getContentType() + "\r\n").getBytes());
                    out.write("Content-Transfer-Encoding: binary\r\n".getBytes());
                    out.write("\r\n".getBytes());
                    try {
                        if (field.getFileInputStream() == null || field.getFileInputStream().available() <= 0) ** GOTO lbl30
                        bytes = new byte[4096];
                        a = 0;
                        while ((a = field.getFileInputStream().read(bytes)) != -1) {
                            out.write(bytes, 0, a);
                            out.flush();
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)field.getFileInputStream());
                    }
                } else {
                    if (field.getContentType() == null) {
                        field.setContentType("text/plain");
                    }
                    out.write(("Content-Disposition: form-data; name=\"" + field.getFieldName() + "\"" + "\r\n").getBytes(this.charset));
                    out.write(("Content-Type: " + field.getContentType() + "; charset=" + this.charset + "\r\n").getBytes());
                    out.write("\r\n".getBytes());
                    if (StringUtils.isNotEmpty((String)field.getFieldValue())) {
                        out.write(field.getFieldValue().getBytes());
                    }
                }
lbl30:
                // 5 sources

                out.write("\r\n".getBytes());
                out.flush();
            }
            out.write(("--" + this.boundary + "--" + "\r\n").getBytes());
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse request() {
        HttpURLConnection httpURLConnection = null;
        InputStream in = null;
        HttpResponse response = new HttpResponse(this.url);
        try {
            response.setRequestTime(System.currentTimeMillis());
            try {
                response.dnsParse();
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                HttpRequestUtils.setRequestProperties(httpURLConnection, this);
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
                OutputStream out = httpURLConnection.getOutputStream();
                this.setRequestFormData(out);
                httpURLConnection.connect();
                HttpRequestUtils.setResponse(httpURLConnection, response);
                try {
                    in = httpURLConnection.getInputStream();
                }
                catch (IOException e) {
                    in = httpURLConnection.getErrorStream();
                }
                if (in != null) {
                    response.setBase64Data(Base64.encodeBase64String((byte[])IOUtils.inputStreamToByteArray(in)));
                }
            }
            catch (UnknownHostException e) {
                response.setExceptionName(e.toString());
            }
        }
        catch (IOException e) {
            response.setExceptionName(e.toString());
        }
        finally {
            IOUtils.closeQuietly(in);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            response.setResponseTime(System.currentTimeMillis());
        }
        return response;
    }
}

