/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.javaweb.core.utils.ClassUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;

public class ASMClassUtils {
    public byte[] createClassWriter(byte[] classfileBuffer, Class<?> targetClass) {
        ClassReader cr = new ClassReader(classfileBuffer);
        if (!ClassUtils.isInterface(cr)) {
            ClassWriter cw = new ClassWriter(cr, 1);
            try {
                ClassVisitor classVisitor = (ClassVisitor)targetClass.getConstructor(Integer.class, ClassWriter.class).newInstance(327680, cw);
                cr.accept(classVisitor, 8);
                return cw.toByteArray();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return classfileBuffer;
    }

    public Map<String, List<AnnotationNode>> getClassAnnotation(byte[] classFileBuffer) {
        LinkedHashMap<String, List<AnnotationNode>> annotationNodeMap = new LinkedHashMap<String, List<AnnotationNode>>();
        final ArrayList classAnnotationNodeList = new ArrayList();
        final ArrayList methodAnnotationNodeList = new ArrayList();
        final ArrayList fieldAnnotationNodeList = new ArrayList();
        ClassReader cr = new ClassReader(classFileBuffer);
        if (!ClassUtils.isInterface(cr)) {
            ClassWriter cw = new ClassWriter(cr, 1);
            cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationNode an = new AnnotationNode(desc);
                    classAnnotationNodeList.add(an);
                    return an;
                }

                public MethodVisitor visitMethod(int access, String methodName, String argTypeDesc, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, methodName, argTypeDesc, signature, exceptions);
                    return new MethodVisitor(327680, mv){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationNode an = new AnnotationNode(desc);
                            methodAnnotationNodeList.add(an);
                            return an;
                        }
                    };
                }

                public FieldVisitor visitField(int access, String methodName, String argTypeDesc, String signature, Object value) {
                    FieldVisitor fv = super.visitField(access, methodName, argTypeDesc, signature, value);
                    return new FieldVisitor(327680, fv){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationNode an = new AnnotationNode(desc);
                            fieldAnnotationNodeList.add(an);
                            return an;
                        }
                    };
                }
            }, 8);
        }
        annotationNodeMap.put("class", classAnnotationNodeList);
        annotationNodeMap.put("method", methodAnnotationNodeList);
        annotationNodeMap.put("field", fieldAnnotationNodeList);
        return annotationNodeMap;
    }
}

