/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BeanValidatorUtils {
    public static <T> ValidationResult beanValidatorSingle(T beanClass, String ... propertyName) {
        return BeanValidatorUtils.beanValidator(beanClass, true, propertyName);
    }

    public static <T> ValidationResult beanValidator(T beanClass, boolean singlePropertyResult, String ... propertyName) {
        HashMap<String, String> errorMsg;
        ValidationResult result;
        block5: {
            result = new ValidationResult();
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            Validator validator = validatorFactory.getValidator();
            errorMsg = new HashMap<String, String>();
            if (propertyName.length > 0) {
                for (String str : propertyName) {
                    Set constraintViolations = validator.validateProperty(beanClass, str, new Class[0]);
                    for (ConstraintViolation constraintViolation : constraintViolations) {
                        errorMsg.put(str, constraintViolation.getMessage());
                        if (!singlePropertyResult) continue;
                        break block5;
                    }
                }
            } else {
                Set constraintViolations = validator.validate(beanClass, new Class[0]);
                for (ConstraintViolation constraintViolation : constraintViolations) {
                    errorMsg.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage());
                    if (!singlePropertyResult) continue;
                    break;
                }
            }
        }
        result.setErrorMsg(errorMsg);
        result.setHasErrors(!errorMsg.isEmpty());
        return result;
    }

    public static class ValidationResult {
        private boolean hasErrors;
        private Map<String, String> errorMsg;

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void setHasErrors(boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        public Map<String, String> getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(Map<String, String> errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String toString() {
            if (this.hasErrors) {
                StringBuilder sb = new StringBuilder();
                for (String key : this.errorMsg.keySet()) {
                    sb.append(this.errorMsg.get(key));
                    if (this.errorMsg.size() <= 1) continue;
                    sb.append("\r\n");
                }
                return sb.toString();
            }
            return "\u9a8c\u8bc1\u901a\u8fc7,\u683c\u5f0f\u6b63\u786e.";
        }
    }
}

