/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import javax.servlet.http.HttpServletRequest;
import org.javaweb.core.utils.StringUtils;

public class CaptchaUtils {
    public static final String ATR_SESSION_TOKEN = "captcha_token";

    public static String generateToken(HttpServletRequest request) {
        String token = StringUtils.getSpecialRandomString(4);
        request.getSession().setAttribute(ATR_SESSION_TOKEN, (Object)token);
        return token;
    }

    private static String getToken(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(ATR_SESSION_TOKEN);
    }

    public static boolean checkToken(HttpServletRequest request, String token) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)token)) {
            return false;
        }
        boolean isValid = token.equalsIgnoreCase(CaptchaUtils.getToken(request));
        request.getSession().removeAttribute(ATR_SESSION_TOKEN);
        return isValid;
    }
}

