/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static void findAllClassFile(File f, String path, Set<String> ls) {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                ClassUtils.findAllClassFile(file, path, ls);
            }
        } else {
            String fileString = f.toString();
            if (fileString.endsWith(".class")) {
                String classPath = fileString.substring(path.length(), fileString.length());
                classPath = classPath.replaceAll("\\\\+", "/").replaceAll("/+", "/").replaceAll("^/", "");
                ls.add(classPath.substring(0, classPath.length() - ".class".length()));
            }
        }
    }

    public static void getAllJarClass(File file, Set<String> classList) throws IOException {
        if (file.isDirectory()) {
            ClassUtils.getAllJarClass(file, classList);
        } else if (file.getName().endsWith(".jar")) {
            ClassUtils.getAllJarClass(file.toURI().toURL(), classList);
        }
    }

    public static void getAllJarClass(URL url, Set<String> classList) throws IOException {
        if (url != null) {
            JarURLConnection juc = (JarURLConnection)url.openConnection();
            JarFile jf = juc.getJarFile();
            Enumeration<JarEntry> je = jf.entries();
            while (je.hasMoreElements()) {
                JarEntry jar = je.nextElement();
                if (!jar.getName().endsWith(".class")) continue;
                String classPath = jar.getName().replaceAll("\\\\", "/").replaceAll("/+", ".");
                classList.add(classPath.substring(0, classPath.length() - ".class".length()));
            }
        }
    }

    public static Set<String> getAllClass() throws IOException {
        LinkedHashSet<String> classList = new LinkedHashSet<String>();
        ClassUtils classUtils = new ClassUtils();
        URL url = ((Object)((Object)classUtils)).getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            if (!"http".equalsIgnoreCase(url.toURI().getScheme()) && new File(url.toURI()).isDirectory()) {
                File f = new File(url.toURI());
                ClassUtils.findAllClassFile(f, f.toString(), classList);
            } else {
                ClassUtils.getAllJarClass(url, classList);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw e;
        }
        return classList;
    }

    public static boolean isInterface(ClassReader cr) {
        return (cr.getAccess() & 0x200) != 0;
    }

    public static int getClassVersion(ClassReader cr) {
        return cr.readUnsignedShort(6);
    }

    private static boolean shouldComputeFrames(ClassReader cr) {
        return ClassUtils.getClassVersion(cr) >= 50;
    }

    public static ClassWriter getClassWriter(ClassReader cr, ClassLoader classLoader) {
        int writerFlags = 1;
        if (ClassUtils.shouldComputeFrames(cr)) {
            writerFlags = 2;
        }
        return new ClassWriter(cr, writerFlags);
    }

    public static Map<String, Object> serializeClassToMap(Object obj) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }
}

