/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayBegin());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayEnd());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, 1);
        return DateUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, day);
        return DateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static Long dateToTimestamp(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = date.toLocaleString();
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getNowTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date getBeginDayOfYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMinimum(1));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDayOfYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getBeginDayOfYear());
        calendar.add(1, 1);
        return calendar.getTime();
    }
}

