/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.javaweb.core.utils.ReflectionUtils;
import org.javaweb.core.utils.StringUtils;

public class DirectiveUtils {
    public static String getString(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model != null) {
            if (model instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)model).getAsString();
            }
            if (model instanceof TemplateNumberModel) {
                return ((TemplateNumberModel)model).getAsNumber().toString();
            }
            throw new TemplateModelException(name);
        }
        return null;
    }

    public static Boolean getBoolean(String name, Map<String, TemplateModel> params) throws TemplateException {
        String str = DirectiveUtils.getString(name, params);
        if (StringUtils.isNotEmpty((String)str)) {
            try {
                return "1".equals(str.trim()) || "true".equals(str.trim());
            }
            catch (Exception e) {
                throw new TemplateModelException(name);
            }
        }
        return null;
    }

    public static Integer getInt(String name, Map params) throws TemplateException {
        Number number = DirectiveUtils.getNumber(name, params);
        if (number != null) {
            return number.intValue();
        }
        return null;
    }

    public static Long getLong(String name, Map params) throws TemplateException {
        Number number = DirectiveUtils.getNumber(name, params);
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    public static Number getNumber(String name, Map params) throws TemplateException {
        String str = DirectiveUtils.getString(name, params);
        try {
            if (StringUtils.isNotEmpty((String)str) && StringUtils.isNum(str)) {
                return NumberFormat.getInstance().parse(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Map<String, TemplateModel> addParamsToVariable(Environment env, Map<String, TemplateModel> params) throws TemplateException {
        HashMap<String, TemplateModel> origMap = new HashMap<String, TemplateModel>();
        if (!params.isEmpty()) {
            Set<Map.Entry<String, TemplateModel>> entrySet = params.entrySet();
            for (Map.Entry<String, TemplateModel> entry : entrySet) {
                String key = entry.getKey();
                TemplateModel value = env.getVariable(key);
                if (value != null) {
                    origMap.put(key, value);
                }
                env.setVariable(key, entry.getValue());
            }
        }
        return origMap;
    }

    public static void removeParamsFromVariable(Environment env, Map<String, TemplateModel> params, Map<String, TemplateModel> origMap) throws TemplateException {
        if (!params.isEmpty()) {
            for (String key : params.keySet()) {
                env.setVariable(key, origMap.get(key));
            }
        }
    }

    public static DefaultObjectWrapper getDefaultObjectWrapper() {
        return new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23).build();
    }

    public static void templateParameterToMap(Map<String, TemplateModel> params, Map<String, String> data) throws TemplateException {
        Set<Map.Entry<String, TemplateModel>> entrySet = params.entrySet();
        for (Map.Entry<String, TemplateModel> entry : entrySet) {
            String key = entry.getKey();
            String value = DirectiveUtils.getString(key, params);
            data.put(key, value);
        }
    }

    public static Map<String, String> getRequestParameter(HttpServletRequest request, Map<String, TemplateModel> params) throws TemplateException {
        HashMap<String, String> data = new HashMap<String, String>();
        if (request != null) {
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                data.put(key, request.getParameter(key));
            }
        }
        DirectiveUtils.templateParameterToMap(params, data);
        return data;
    }

    public static <T> T parameterMap2Bean(Map<String, TemplateModel> params, Class<T> entityClass) throws TemplateException {
        return DirectiveUtils.parameterMap2Bean(null, params, entityClass);
    }

    public static <T> T parameterMap2Bean(HttpServletRequest request, Map<String, TemplateModel> params, Class<T> entityClass) throws TemplateException {
        Map<String, String> data = DirectiveUtils.getRequestParameter(request, params);
        return (T)JSONObject.parseObject((String)JSON.toJSONString(data), entityClass);
    }

    public static <T> T paramsMap2Bean(Map params, Class<T> entityClass) throws TemplateException {
        Set entrySet = params.entrySet();
        Map<String, Method> methodMap = ReflectionUtils.getAllMethodsMap(entityClass);
        Map<String, Field> fieldMap = ReflectionUtils.getAllFieldsMap(entityClass);
        T instance = null;
        try {
            instance = entityClass.newInstance();
            for (Map.Entry entry : entrySet) {
                Method method;
                String key = (String)entry.getKey();
                String field = key.toLowerCase().replaceAll("_", "");
                String setColumnName = "set" + field;
                if (!methodMap.containsKey(setColumnName) || !fieldMap.containsKey(field) || (method = methodMap.get(setColumnName)).getParameterTypes().length != 1) continue;
                try {
                    String valueStr = DirectiveUtils.getString(key, params);
                    Object value = null;
                    String className = method.getParameterTypes()[0].getName();
                    if (!StringUtils.isNotEmpty((String)valueStr)) continue;
                    if (StringUtils.isNum(valueStr.toString())) {
                        try {
                            Number number = NumberFormat.getInstance().parse(valueStr.toString());
                            if (className.equals("java.lang.Integer") || className.equals("int")) {
                                method.invoke(instance, number.intValue());
                                continue;
                            }
                            if (className.equals("java.lang.Long") || className.equals("long")) {
                                method.invoke(instance, number.longValue());
                                continue;
                            }
                            if (className.equals("java.lang.Double") || className.equals("double")) {
                                method.invoke(instance, number.doubleValue());
                                continue;
                            }
                            if (className.equals("java.lang.Float") || className.equals("float")) {
                                method.invoke(instance, Float.valueOf(number.floatValue()));
                                continue;
                            }
                            if (className.equals("java.lang.Byte") || className.equals("byte")) {
                                method.invoke(instance, number.byteValue());
                                continue;
                            }
                            if (className.equals("java.lang.Short") || className.equals("short")) {
                                method.invoke(instance, number.shortValue());
                                continue;
                            }
                            if (className.equals("java.lang.Boolean") || className.equals("boolean")) {
                                method.invoke(instance, 1 == number.intValue());
                                continue;
                            }
                            if (!className.equals("java.util.Date")) continue;
                            method.invoke(instance, new Date(number.longValue()));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (className.equals("java.lang.Boolean") || className.equals("boolean")) {
                        method.invoke(instance, "true".equalsIgnoreCase(valueStr.toString()));
                        continue;
                    }
                    if (className.equals("java.lang.Char") || className.equals("char")) {
                        method.invoke(instance, Character.valueOf(valueStr.toString().charAt(0)));
                        continue;
                    }
                    if (className.equals("java.lang.String")) {
                        method.invoke(instance, valueStr);
                        continue;
                    }
                    if (className.equals("java.lang.StringBuffer")) {
                        method.invoke(instance, new StringBuffer(valueStr));
                        continue;
                    }
                    if (!className.equals("java.lang.StringBuilder")) continue;
                    method.invoke(instance, new StringBuilder(valueStr));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

